/**
 * Salieno Client Area Core JS
 * Handles theme management, SPA navigation states, and global notifications.
 */

document.addEventListener('alpine:init', () => {
    // 1. Navigation Store - Tracks Livewire SPA states
    Alpine.store('navigation', {
        isNavigating: false,
        start() {
            this.isNavigating = true;
            document.body.classList.add('navigating');
        },
        end() {
            this.isNavigating = false;
            document.body.classList.remove('navigating');
        }
    });
});

// 2. Global Event Listeners for Livewire Navigation
document.addEventListener('livewire:navigate', () => {
    if (window.Alpine && Alpine.store('navigation')) {
        Alpine.store('navigation').start();
    }
});

document.addEventListener('livewire:navigated', () => {
    if (window.Alpine && Alpine.store('navigation')) {
        Alpine.store('navigation').end();
    }
});

/**
 * Global Toast Helper
 * Dispatches a 'toast' event that is caught by the x-client.toast component.
 * @param {Object} options - { title, message, type, duration }
 */
window.toast = function (options) {
    window.dispatchEvent(new CustomEvent('toast', { detail: options }));
};

/**
 * Global Notify Helper (Alias for broader template compatibility)
 */
window.notify = function (type, message) {
    if (!message) {
        message = type;
        type = 'info';
    }
    window.toast({ message: message, type: type });
};
