<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    
    <title>Admin Login - Salieno</title>
    
    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.bunny.net">
    <link href="https://fonts.bunny.net/css?family=inter:400,500,600,700&display=swap" rel="stylesheet" />
    
    <!-- Icons -->
    <link rel="stylesheet" href="https://unpkg.com/@phosphor-icons/web@2.0.3/src/duotone/style.css" />
    
    @vite(['resources/css/app.css', 'resources/js/app.js'])
</head>
<body class="min-h-screen bg-gradient-to-br from-slate-900 via-slate-800 to-slate-900">
    <div class="flex min-h-screen">
        <!-- Left Side - Branding -->
        <div class="hidden w-1/2 flex-col justify-between p-12 lg:flex">
            <div>
                <a href="/" class="inline-flex items-center gap-3">
                    <div class="flex h-10 w-10 items-center justify-center rounded-xl bg-primary-500">
                        <i class="ph-duotone ph-cloud text-xl text-white"></i>
                    </div>
                    <span class="text-2xl font-bold text-white">Salieno</span>
                </a>
            </div>
            
            <div class="max-w-md">
                <h1 class="text-4xl font-bold leading-tight text-white">
                    Powerful Hosting Management Made Simple
                </h1>
                <p class="mt-4 text-lg text-slate-400">
                    Manage your hosting business with an enterprise-grade platform designed for scale.
                </p>
                
                <div class="mt-8 grid grid-cols-2 gap-4">
                    <div class="rounded-xl bg-white/5 p-4 backdrop-blur-sm">
                        <i class="ph-duotone ph-users text-2xl text-primary-400"></i>
                        <p class="mt-2 text-sm font-medium text-white">10,000+</p>
                        <p class="text-xs text-slate-400">Active Users</p>
                    </div>
                    <div class="rounded-xl bg-white/5 p-4 backdrop-blur-sm">
                        <i class="ph-duotone ph-server text-2xl text-success-400"></i>
                        <p class="mt-2 text-sm font-medium text-white">99.9%</p>
                        <p class="text-xs text-slate-400">Uptime</p>
                    </div>
                    <div class="rounded-xl bg-white/5 p-4 backdrop-blur-sm">
                        <i class="ph-duotone ph-globe text-2xl text-info-400"></i>
                        <p class="mt-2 text-sm font-medium text-white">50+</p>
                        <p class="text-xs text-slate-400">Countries</p>
                    </div>
                    <div class="rounded-xl bg-white/5 p-4 backdrop-blur-sm">
                        <i class="ph-duotone ph-shield-check text-2xl text-warning-400"></i>
                        <p class="mt-2 text-sm font-medium text-white">Enterprise</p>
                        <p class="text-xs text-slate-400">Security</p>
                    </div>
                </div>
            </div>
            
            <p class="text-sm text-slate-500">
                &copy; {{ date('Y') }} Salieno. All rights reserved.
            </p>
        </div>
        
        <!-- Right Side - Login Form -->
        <div class="flex w-full items-center justify-center p-8 lg:w-1/2">
            <div class="w-full max-w-md">
                <!-- Mobile Logo -->
                <div class="mb-8 text-center lg:hidden">
                    <a href="/" class="inline-flex items-center gap-3">
                        <div class="flex h-10 w-10 items-center justify-center rounded-xl bg-primary-500">
                            <i class="ph-duotone ph-cloud text-xl text-white"></i>
                        </div>
                        <span class="text-2xl font-bold text-white">Salieno</span>
                    </a>
                </div>
                
                <div class="rounded-2xl bg-white p-8 shadow-2xl">
                    <div class="mb-8 text-center">
                        <h2 class="text-2xl font-bold text-slate-900">Welcome back</h2>
                        <p class="mt-2 text-sm text-slate-500">Sign in to your admin account</p>
                    </div>
                    
                    <form method="POST" action="{{ route('admin.login') }}" class="space-y-5">
                        @csrf
                        
                        <div>
                            <label for="username" class="mb-1.5 block text-sm font-medium text-slate-700">
                                Username
                            </label>
                            <div class="relative">
                                <div class="pointer-events-none absolute inset-y-0 left-0 flex items-center pl-3">
                                    <i class="ph-duotone ph-user text-lg text-slate-400"></i>
                                </div>
                                <input 
                                    type="text" 
                                    id="username" 
                                    name="username"
                                    value="{{ old('username') }}"
                                    class="w-full rounded-xl border border-slate-200 bg-slate-50 py-3 pl-10 pr-4 text-sm text-slate-900 placeholder-slate-400 transition-all focus:border-primary-500 focus:bg-white focus:outline-none focus:ring-2 focus:ring-primary-500/20"
                                    placeholder="Enter your username"
                                    required
                                    autofocus
                                >
                            </div>
                            @error('username')
                                <p class="mt-1.5 text-sm text-danger-600">{{ $message }}</p>
                            @enderror
                        </div>
                        
                        <div>
                            <label for="password" class="mb-1.5 block text-sm font-medium text-slate-700">
                                Password
                            </label>
                            <div class="relative" x-data="{ show: false }">
                                <div class="pointer-events-none absolute inset-y-0 left-0 flex items-center pl-3">
                                    <i class="ph-duotone ph-lock text-lg text-slate-400"></i>
                                </div>
                                <input 
                                    :type="show ? 'text' : 'password'" 
                                    id="password" 
                                    name="password"
                                    class="w-full rounded-xl border border-slate-200 bg-slate-50 py-3 pl-10 pr-12 text-sm text-slate-900 placeholder-slate-400 transition-all focus:border-primary-500 focus:bg-white focus:outline-none focus:ring-2 focus:ring-primary-500/20"
                                    placeholder="Enter your password"
                                    required
                                >
                                <button 
                                    type="button"
                                    @click="show = !show"
                                    class="absolute inset-y-0 right-0 flex items-center pr-3 text-slate-400 hover:text-slate-600"
                                >
                                    <i class="ph-duotone text-lg" :class="show ? 'ph-eye-slash' : 'ph-eye'"></i>
                                </button>
                            </div>
                            @error('password')
                                <p class="mt-1.5 text-sm text-danger-600">{{ $message }}</p>
                            @enderror
                        </div>
                        
                        <div class="flex items-center justify-between">
                            <label class="flex cursor-pointer items-center gap-2">
                                <input type="checkbox" name="remember" class="h-4 w-4 rounded border-slate-300 text-primary-600 focus:ring-primary-500">
                                <span class="text-sm text-slate-600">Remember me</span>
                            </label>
                            <a href="#" class="text-sm font-medium text-primary-600 hover:text-primary-700">
                                Forgot password?
                            </a>
                        </div>
                        
                        <button 
                            type="submit"
                            class="flex w-full items-center justify-center gap-2 rounded-xl bg-primary-600 px-4 py-3 text-sm font-semibold text-white shadow-lg shadow-primary-500/30 transition-all hover:bg-primary-700 hover:shadow-xl hover:shadow-primary-500/40 focus:outline-none focus:ring-2 focus:ring-primary-500 focus:ring-offset-2"
                        >
                            <span>Sign in</span>
                            <i class="ph-bold ph-arrow-right"></i>
                        </button>
                    </form>
                </div>
                
                <p class="mt-6 text-center text-sm text-slate-400 lg:hidden">
                    &copy; {{ date('Y') }} Salieno. All rights reserved.
                </p>
            </div>
        </div>
    </div>
    
    <!-- Alpine.js -->
    <script defer src="https://unpkg.com/alpinejs@3.x.x/dist/cdn.min.js"></script>
</body>
</html>

