<x-layouts.admin title="Component Library">
    <x-slot name="breadcrumbs">
        <x-admin.breadcrumb-item>System</x-admin.breadcrumb-item>
        <x-admin.breadcrumb-item active>Component Library</x-admin.breadcrumb-item>
    </x-slot>

    <x-slot name="header">
        <x-admin.page-header 
            title="Component Library" 
            subtitle="A showcase of all available admin UI components"
        >
            <x-slot name="actions">
                <x-admin.button variant="secondary" icon="ph-code">View Code</x-admin.button>
            </x-slot>
        </x-admin.page-header>
    </x-slot>

    <!-- Buttons Section -->
    <x-admin.card title="Buttons" subtitle="Various button styles and states" class="mb-8">
        <div class="space-y-6">
            <div>
                <h4 class="mb-3 text-sm font-medium text-slate-500">Variants</h4>
                <div class="flex flex-wrap gap-3">
                    <x-admin.button>Primary</x-admin.button>
                    <x-admin.button variant="secondary">Secondary</x-admin.button>
                    <x-admin.button variant="success">Success</x-admin.button>
                    <x-admin.button variant="danger">Danger</x-admin.button>
                    <x-admin.button variant="ghost">Ghost</x-admin.button>
                </div>
            </div>
            
            <div>
                <h4 class="mb-3 text-sm font-medium text-slate-500">With Icons</h4>
                <div class="flex flex-wrap gap-3">
                    <x-admin.button icon="ph-plus">Create New</x-admin.button>
                    <x-admin.button variant="secondary" icon="ph-download">Export</x-admin.button>
                    <x-admin.button variant="danger" icon="ph-trash">Delete</x-admin.button>
                    <x-admin.button variant="ghost" icon="ph-gear"></x-admin.button>
                </div>
            </div>
            
            <div>
                <h4 class="mb-3 text-sm font-medium text-slate-500">Sizes</h4>
                <div class="flex flex-wrap items-center gap-3">
                    <x-admin.button size="xs">Extra Small</x-admin.button>
                    <x-admin.button size="sm">Small</x-admin.button>
                    <x-admin.button>Default</x-admin.button>
                    <x-admin.button size="lg">Large</x-admin.button>
                </div>
            </div>
            
            <div>
                <h4 class="mb-3 text-sm font-medium text-slate-500">States</h4>
                <div class="flex flex-wrap gap-3">
                    <x-admin.button :loading="true">Loading...</x-admin.button>
                    <x-admin.button :disabled="true">Disabled</x-admin.button>
                </div>
            </div>
        </div>
    </x-admin.card>

    <!-- Badges Section -->
    <x-admin.card title="Badges" subtitle="Status indicators and labels" class="mb-8">
        <div class="space-y-6">
            <div>
                <h4 class="mb-3 text-sm font-medium text-slate-500">Types</h4>
                <div class="flex flex-wrap gap-3">
                    <x-admin.badge type="primary">Primary</x-admin.badge>
                    <x-admin.badge type="success">Success</x-admin.badge>
                    <x-admin.badge type="warning">Warning</x-admin.badge>
                    <x-admin.badge type="danger">Danger</x-admin.badge>
                    <x-admin.badge type="info">Info</x-admin.badge>
                    <x-admin.badge type="neutral">Neutral</x-admin.badge>
                </div>
            </div>
            
            <div>
                <h4 class="mb-3 text-sm font-medium text-slate-500">With Dot</h4>
                <div class="flex flex-wrap gap-3">
                    <x-admin.badge type="success" dot>Active</x-admin.badge>
                    <x-admin.badge type="warning" dot>Pending</x-admin.badge>
                    <x-admin.badge type="danger" dot>Suspended</x-admin.badge>
                    <x-admin.badge type="success" dot pulse>Live</x-admin.badge>
                </div>
            </div>
        </div>
    </x-admin.card>

    <!-- Alerts Section -->
    <x-admin.card title="Alerts" subtitle="System messages and notifications" class="mb-8">
        <div class="space-y-4">
            <x-admin.alert type="info" title="Information">
                This is an informational alert. It provides helpful context.
            </x-admin.alert>
            
            <x-admin.alert type="success" title="Success" dismissible>
                Your changes have been saved successfully!
            </x-admin.alert>
            
            <x-admin.alert type="warning" title="Warning">
                Please review your settings before proceeding.
            </x-admin.alert>
            
            <x-admin.alert type="danger" title="Error">
                An error occurred while processing your request.
            </x-admin.alert>
        </div>
    </x-admin.card>

    <!-- Form Inputs Section -->
    <x-admin.card title="Form Inputs" subtitle="Input fields and form controls" class="mb-8">
        <div class="grid gap-6 md:grid-cols-2">
            <x-admin.input 
                label="Text Input" 
                name="demo_text" 
                placeholder="Enter text..."
                helper="This is a helper text"
            />
            
            <x-admin.input 
                label="With Icon" 
                name="demo_icon" 
                icon="ph-magnifying-glass"
                placeholder="Search..."
            />
            
            <x-admin.input 
                label="Email" 
                name="demo_email" 
                type="email"
                placeholder="you@example.com"
                required
            />
            
            <x-admin.input 
                label="With Error" 
                name="demo_error" 
                error="This field is required"
            />
            
            <x-admin.select 
                label="Select Input" 
                name="demo_select"
                placeholder="Choose an option"
                :options="['option1' => 'Option 1', 'option2' => 'Option 2', 'option3' => 'Option 3']"
            />
            
            <div class="flex flex-col justify-end">
                <x-admin.toggle label="Toggle Switch" name="demo_toggle" helper="Enable this feature" />
            </div>
            
            <div class="md:col-span-2">
                <x-admin.textarea 
                    label="Textarea" 
                    name="demo_textarea"
                    placeholder="Enter your message..."
                    rows="3"
                />
            </div>
        </div>
    </x-admin.card>
</x-layouts.admin>

