<x-layouts.admin title="Dashboard">
    <x-slot name="header">
        <div class="flex flex-col gap-4 sm:flex-row sm:items-center sm:justify-between">
            <div>
                <h1 class="text-2xl font-bold text-slate-900">Welcome back, Admin</h1>
                <p class="mt-1 text-sm text-slate-500">Here's what's happening with your business today.</p>
            </div>
            <div class="flex gap-3">
                <x-admin.button variant="secondary" icon="ph-download">
                    Export Report
                </x-admin.button>
                <x-admin.button icon="ph-plus">
                    Quick Action
                </x-admin.button>
            </div>
        </div>
    </x-slot>

    <!-- Stats Grid -->
    <div class="grid gap-6 sm:grid-cols-2 lg:grid-cols-4">
        <x-admin.stat-card 
            icon="ph-currency-dollar" 
            iconColor="success"
            label="Total Revenue"
            value="$45,231.89"
            :trend="12.5"
            href="#"
        />
        <x-admin.stat-card 
            icon="ph-users" 
            iconColor="primary"
            label="Active Clients"
            value="2,420"
            :trend="8.2"
            href="#"
        />
        <x-admin.stat-card 
            icon="ph-shopping-cart" 
            iconColor="info"
            label="Active Services"
            value="1,893"
            :trend="-2.4"
            href="#"
        />
        <x-admin.stat-card 
            icon="ph-chat-circle-dots" 
            iconColor="warning"
            label="Open Tickets"
            value="24"
            :trend="4.7"
            href="#"
        />
    </div>

    <!-- Main Content Grid -->
    <div class="mt-8 grid gap-6 lg:grid-cols-3">
        <!-- Recent Orders - Takes 2 columns -->
        <div class="lg:col-span-2">
            <x-admin.card title="Recent Orders" subtitle="Latest orders from your clients" :padding="false">
                <x-slot name="actions">
                    <x-admin.button variant="ghost" size="sm">View All</x-admin.button>
                </x-slot>
                
                <div class="overflow-x-auto">
                    <table class="data-table">
                        <thead>
                            <tr>
                                <th>Order ID</th>
                                <th>Client</th>
                                <th>Product</th>
                                <th>Status</th>
                                <th>Amount</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <td class="font-medium text-slate-900">#ORD-7845</td>
                                <td>
                                    <div class="flex items-center gap-3">
                                        <div class="flex h-8 w-8 items-center justify-center rounded-full bg-primary-100 text-sm font-medium text-primary-700">JD</div>
                                        <span>John Doe</span>
                                    </div>
                                </td>
                                <td>Premium Hosting</td>
                                <td><x-admin.badge type="success" dot pulse>Active</x-admin.badge></td>
                                <td class="font-medium">$29.99</td>
                            </tr>
                            <tr>
                                <td class="font-medium text-slate-900">#ORD-7844</td>
                                <td>
                                    <div class="flex items-center gap-3">
                                        <div class="flex h-8 w-8 items-center justify-center rounded-full bg-success-100 text-sm font-medium text-success-700">SM</div>
                                        <span>Sarah Miller</span>
                                    </div>
                                </td>
                                <td>VPS Server</td>
                                <td><x-admin.badge type="warning" dot>Pending</x-admin.badge></td>
                                <td class="font-medium">$49.99</td>
                            </tr>
                            <tr>
                                <td class="font-medium text-slate-900">#ORD-7843</td>
                                <td>
                                    <div class="flex items-center gap-3">
                                        <div class="flex h-8 w-8 items-center justify-center rounded-full bg-info-100 text-sm font-medium text-info-700">RJ</div>
                                        <span>Robert Johnson</span>
                                    </div>
                                </td>
                                <td>Domain .com</td>
                                <td><x-admin.badge type="success" dot>Active</x-admin.badge></td>
                                <td class="font-medium">$12.99</td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </x-admin.card>
        </div>

        <!-- Activity Feed -->
        <x-admin.card title="Recent Activity" subtitle="What's happening now">
            <div class="space-y-4">
                <div class="flex gap-3">
                    <div class="flex h-9 w-9 shrink-0 items-center justify-center rounded-full bg-success-50 text-success-600">
                        <i class="ph-duotone ph-credit-card text-lg"></i>
                    </div>
                    <div>
                        <p class="text-sm font-medium text-slate-900">Payment received</p>
                        <p class="text-xs text-slate-500">$125.00 from John Doe</p>
                        <p class="mt-1 text-xs text-slate-400">2 minutes ago</p>
                    </div>
                </div>
                <div class="flex gap-3">
                    <div class="flex h-9 w-9 shrink-0 items-center justify-center rounded-full bg-primary-50 text-primary-600">
                        <i class="ph-duotone ph-user-plus text-lg"></i>
                    </div>
                    <div>
                        <p class="text-sm font-medium text-slate-900">New client registered</p>
                        <p class="text-xs text-slate-500">sarah@example.com</p>
                        <p class="mt-1 text-xs text-slate-400">15 minutes ago</p>
                    </div>
                </div>
                <div class="flex gap-3">
                    <div class="flex h-9 w-9 shrink-0 items-center justify-center rounded-full bg-warning-50 text-warning-600">
                        <i class="ph-duotone ph-chat-circle-dots text-lg"></i>
                    </div>
                    <div>
                        <p class="text-sm font-medium text-slate-900">New support ticket</p>
                        <p class="text-xs text-slate-500">#TKT-1234: Server issues</p>
                        <p class="mt-1 text-xs text-slate-400">1 hour ago</p>
                    </div>
                </div>
            </div>
        </x-admin.card>
    </div>
</x-layouts.admin>

