<x-layouts.admin :title="$pageTitle">
    <x-admin.page-header :title="$pageTitle" :subtitle="__('Authorize your installation to unlock premium capabilities.')">
        <x-slot:actions>
             <x-admin.button href="{{ route('admin.system.status') }}" variant="secondary" icon="ph-activity">
                @lang('Check Status')
            </x-admin.button>
        </x-slot:actions>
    </x-admin.page-header>

    {{-- Statistics Cards --}}
    <div class="mt-4 sm:mt-6 grid grid-cols-2 gap-2 sm:gap-4 lg:grid-cols-4">
        <x-admin.stat-card
            icon="ph-cpu"
            iconColor="primary"
            :label="__('Kernel Version')"
            value="v1.0.0"
        />
        <x-admin.stat-card
            icon="ph-code"
            iconColor="info"
            :label="__('PHP Version')"
            :value="PHP_MAJOR_VERSION . '.' . PHP_MINOR_VERSION"
        />
        <x-admin.stat-card
            icon="ph-database"
            iconColor="warning"
            :label="__('Database')"
            :value="ucfirst(config('database.default'))"
        />
        <x-admin.stat-card
            icon="ph-globe-stand"
            iconColor="success"
            :label="__('Environment')"
            :value="strtoupper(app()->environment())"
        />
    </div>

    <div class="mt-4 sm:mt-6 grid grid-cols-1 lg:grid-cols-2 gap-4 sm:gap-6">
        {{-- Handshake Card --}}
        <x-admin.card class="h-fit">
            <div class="flex items-center gap-3 pb-3 sm:pb-4 mb-4 sm:mb-5 border-b border-white/5">
                <div class="flex h-9 w-9 sm:h-10 sm:w-10 shrink-0 items-center justify-center rounded-xl bg-gradient-to-br from-indigo-500/20 to-purple-500/20">
                    <i class="ph-duotone ph-lightning text-lg sm:text-xl text-indigo-400"></i>
                </div>
                <div class="min-w-0">
                    <h3 class="font-semibold text-white text-sm sm:text-base">@lang('Initialize Handshake')</h3>
                    <p class="text-xs sm:text-sm text-slate-500 truncate">@lang('Connect to Salieno Intelligence')</p>
                </div>
            </div>

            <div class="space-y-6">
                <p class="text-sm text-slate-400 leading-relaxed">
                    @lang('Connect this installation to the central Salieno Intelligence Network to synchronize license tiers, security modules, and automated updates.')
                </p>

                <div class="p-4 rounded-xl bg-white/5 border border-white/5 flex items-center justify-between gap-4">
                    <div class="space-y-1">
                        <p class="text-[10px] font-bold text-slate-500 uppercase tracking-widest">@lang('System Fingerprint')</p>
                        <p class="text-xs font-mono text-indigo-400">{{ substr(getInstallationHash(), 0, 16) }}...</p>
                    </div>
                    <div class="flex h-8 w-8 items-center justify-center rounded-lg bg-indigo-500/10">
                        <i class="ph-bold ph-fingerprint text-indigo-400"></i>
                    </div>
                </div>

                <div class="pt-2">
                    <x-admin.button href="{{ route('admin.system.connect') }}" fullWidth icon="ph-link">
                        @lang('Establish Connection')
                    </x-admin.button>
                </div>
            </div>
        </x-admin.card>

        {{-- Verification Points --}}
        <x-admin.card class="h-fit">
            <div class="flex items-center gap-3 pb-3 sm:pb-4 mb-4 sm:mb-5 border-b border-white/5">
                <div class="flex h-9 w-9 sm:h-10 sm:w-10 shrink-0 items-center justify-center rounded-xl bg-gradient-to-br from-emerald-500/20 to-teal-500/20">
                    <i class="ph-duotone ph-shield-check text-lg sm:text-xl text-emerald-400"></i>
                </div>
                <div class="min-w-0">
                    <h3 class="font-semibold text-white text-sm sm:text-base">@lang('Security Verification')</h3>
                    <p class="text-xs sm:text-sm text-slate-500 truncate">@lang('What to expect after connection')</p>
                </div>
            </div>

            <div class="space-y-4">
                <div class="flex gap-4 p-3 rounded-xl transition-colors hover:bg-white/5">
                    <div class="flex h-10 w-10 shrink-0 items-center justify-center rounded-xl bg-indigo-500/10">
                        <i class="ph-bold ph-lock-key text-indigo-400"></i>
                    </div>
                    <div>
                        <h4 class="text-sm font-bold text-white">@lang('Cryptographic Identity')</h4>
                        <p class="text-xs text-slate-500 mt-1">@lang('Your node receives a unique certificate for encrypted communication.')</p>
                    </div>
                </div>

                <div class="flex gap-4 p-3 rounded-xl transition-colors hover:bg-white/5">
                    <div class="flex h-10 w-10 shrink-0 items-center justify-center rounded-xl bg-purple-500/10">
                        <i class="ph-bold ph-arrows-clockwise text-purple-400"></i>
                    </div>
                    <div>
                        <h4 class="text-sm font-bold text-white">@lang('Dynamic Tiers')</h4>
                        <p class="text-xs text-slate-500 mt-1">@lang('System capabilities update instantly based on your active subscription.')</p>
                    </div>
                </div>

                <div class="flex gap-4 p-3 rounded-xl transition-colors hover:bg-white/5">
                    <div class="flex h-10 w-10 shrink-0 items-center justify-center rounded-xl bg-emerald-500/10">
                        <i class="ph-bold ph-cloud-arrow-down text-emerald-400"></i>
                    </div>
                    <div>
                        <h4 class="text-sm font-bold text-white">@lang('Module Intelligence')</h4>
                        <p class="text-xs text-slate-500 mt-1">@lang('Real-time security patches and feature streams from the core network.')</p>
                    </div>
                </div>
            </div>
        </x-admin.card>
    </div>

    <div class="mt-6 flex items-center justify-center gap-2">
        <span class="relative flex h-2 w-2">
            <span class="absolute inline-flex h-full w-full animate-ping rounded-full bg-rose-500 opacity-75"></span>
            <span class="relative inline-flex h-2 w-2 rounded-full bg-rose-500"></span>
        </span>
        <span class="text-[10px] font-bold text-slate-500 uppercase tracking-[0.2em]">@lang('Awaiting Activation')</span>
    </div>
</x-layouts.admin>
