<x-layouts.admin :title="$pageTitle">
    <x-admin.page-header :title="$pageTitle" :subtitle="__('View your current system registration status and details.')">
        <x-slot:actions>
            <form action="{{ route('admin.system.recheck') }}" method="POST" class="inline">
                @csrf
                <x-admin.button type="submit" variant="secondary" size="sm" icon="ph-duotone ph-arrows-clockwise">
                    @lang('Re-check License')
                </x-admin.button>
            </form>
        </x-slot:actions>
    </x-admin.page-header>

    @if(!$capabilities['valid'])
        <x-admin.alert type="danger" :title="__('System Access Restricted')" class="mt-4 sm:mt-6">
            <p>{{ $capabilities['message'] ?? __('This installation has been suspended or banned from the Salieno network due to security violations or subscription expiry.') }}</p>
            <div class="mt-4 flex flex-wrap gap-3">
                <x-admin.button href="{{ route('admin.system.register') }}" size="sm" variant="danger">
                    <i class="ph-bold ph-key mr-2"></i>
                    @lang('Re-authenticate Node')
                </x-admin.button>
                <form action="{{ route('admin.system.recheck') }}" method="POST" class="inline">
                    @csrf
                    <x-admin.button type="submit" size="sm" variant="secondary">
                        <i class="ph-bold ph-arrows-clockwise mr-2"></i>
                        @lang('Re-check License Status')
                    </x-admin.button>
                </form>
            </div>
        </x-admin.alert>
    @endif

    {{-- Statistics Cards --}}
    <div class="mt-4 sm:mt-6 grid grid-cols-2 gap-2 sm:gap-4 lg:grid-cols-4">
        <x-admin.stat-card
            icon="ph-identification-badge"
            iconColor="primary"
            :label="__('License Tier')"
            :value="ucfirst($capabilities['tier'] ?? 'Standard')"
        />
        <x-admin.stat-card
            icon="{{ $capabilities['valid'] ? 'ph-check-circle' : 'ph-x-circle' }}"
            iconColor="{{ $capabilities['valid'] ? 'success' : 'danger' }}"
            :label="__('Status')"
            :value="strtoupper($capabilities['status'] ?? 'INACTIVE')"
        />
        <x-admin.stat-card
            icon="ph-calendar"
            iconColor="info"
            :label="__('Expires')"
            :value="$capabilities['expires_at'] ? \Carbon\Carbon::parse($capabilities['expires_at'])->format('M d, Y') : __('Lifetime')"
        />
        <x-admin.stat-card
            icon="ph-clock-clockwise"
            iconColor="warning"
            :label="__('Last Validated')"
            :value="$capabilities['last_validated'] ? \Carbon\Carbon::parse($capabilities['last_validated'])->diffForHumans() : __('Never')"
        />
    </div>

    <div class="mt-4 sm:mt-6 grid lg:grid-cols-2 gap-4 sm:gap-6">
        {{-- Installation Details --}}
        <x-admin.card :title="__('Installation Details')" icon="ph-monitor">
            <div class="space-y-4">
                <div class="flex items-center justify-between py-2 border-b border-white/5">
                    <span class="text-slate-500 text-sm">@lang('Domain')</span>
                    <span class="text-white font-medium text-sm">{{ request()->getHost() }}</span>
                </div>
                <div class="flex items-center justify-between py-2 border-b border-white/5">
                    <span class="text-slate-500 text-sm">@lang('IP Address')</span>
                    <span class="text-white font-medium text-sm">{{ request()->ip() }}</span>
                </div>
                <div class="flex items-center justify-between py-2 border-b border-white/5">
                    <span class="text-slate-500 text-sm">@lang('Node ID')</span>
                    <span class="text-white font-mono text-xs">{{ substr(getInstallationHash(), 0, 16) }}...</span>
                </div>
                <div class="flex items-center justify-between py-2">
                    <span class="text-slate-500 text-sm">@lang('Environment')</span>
                    <x-admin.badge type="{{ app()->isProduction() ? 'success' : 'warning' }}" size="sm">
                        {{ strtoupper(app()->environment()) }}
                    </x-admin.badge>
                </div>
            </div>
        </x-admin.card>

        {{-- License Information --}}
        <x-admin.card :title="__('License Information')" icon="ph-shield-check">
            <div class="space-y-4">
                 <div class="flex items-center justify-between py-2 border-b border-white/5">
                    <span class="text-slate-500 text-sm">@lang('Connection Status')</span>
                    @if($capabilities['valid'])
                        <x-admin.badge type="success" size="sm" dot pulse>@lang('Secure')</x-admin.badge>
                    @else
                        <x-admin.badge type="danger" size="sm" dot>@lang('Disconnected')</x-admin.badge>
                    @endif
                </div>
                @if($registrationToken)
                <div class="flex items-center justify-between py-2 border-b border-white/5">
                    <span class="text-slate-500 text-sm">@lang('License Key')</span>
                    <span class="text-white font-mono text-xs">•••• •••• •••• {{ substr($registrationToken, -5) }}</span>
                </div>
                @endif
                <div class="flex items-center justify-between py-2 border-b border-white/5">
                    <span class="text-slate-500 text-sm">@lang('License Holder')</span>
                    <span class="text-white font-medium text-sm">{{ $capabilities['license_holder'] ?? 'Salieno Network' }}</span>
                </div>
                <div class="flex items-center justify-between py-2 border-b border-white/5">
                    <span class="text-slate-500 text-sm">@lang('Purchased')</span>
                    <span class="text-white font-medium text-sm">{{ ($capabilities['purchased_at'] ?? null) ? \Carbon\Carbon::parse($capabilities['purchased_at'])->format('M d, Y') : __('N/A') }}</span>
                </div>
                <div class="flex items-center justify-between py-2 border-b border-white/5">
                    <span class="text-slate-500 text-sm">@lang('Activated')</span>
                    <span class="text-white font-medium text-sm">{{ ($capabilities['activated_at'] ?? null) ? \Carbon\Carbon::parse($capabilities['activated_at'])->format('M d, Y') : __('N/A') }}</span>
                </div>
                <div class="flex items-center justify-between py-2 border-b border-white/5">
                    <span class="text-slate-500 text-sm">@lang('Update Stream')</span>
                    <span class="text-indigo-400 font-bold text-sm">STABLE</span>
                </div>
                <div class="flex items-center justify-between py-2">
                    <span class="text-slate-500 text-sm">@lang('Encryption')</span>
                    <span class="text-emerald-400 font-mono text-[10px]">AES-256-GCM / HMAC</span>
                </div>
            </div>
        </x-admin.card>
    </div>

    {{-- Actions: Always show Remove Registration --}}
    <x-admin.card class="mt-4 sm:mt-6 border-rose-500/10" :padding="false">
        <div class="bg-rose-500/5 px-4 sm:px-6 py-4 sm:py-6 flex flex-col sm:flex-row sm:items-center justify-between gap-4">
            <div class="flex items-start gap-4">
                <div class="flex h-10 w-10 shrink-0 items-center justify-center rounded-xl bg-rose-500/20">
                    <i class="ph-duotone ph-warning-octagon text-rose-500 text-xl"></i>
                </div>
                <div>
                    <h4 class="text-white font-bold text-sm sm:text-base">@lang('Remove Node Registration')</h4>
                    <p class="text-xs sm:text-sm text-slate-400">@lang('Clear all local license data so you can register a new license. This action is irreversible.')</p>
                </div>
            </div>
            <form action="{{ route('admin.system.deactivate') }}" method="POST" x-data @submit.prevent="if(confirm('@lang('WARNING: This will clear all local license data on this node. Proceed?')')) $el.submit()">
                @csrf
                <x-admin.button type="submit" variant="danger" size="sm" icon="ph-trash">
                    @lang('Remove Registration')
                </x-admin.button>
            </form>
        </div>
    </x-admin.card>
</x-layouts.admin>
