@props([
    'icon' => null,
    'href' => null,
    'danger' => false,
    'variant' => null,
    'divider' => false,
    'description' => null,
])

@if($divider)
    <hr class="my-2 border-white/5">
@else
    @php
        $isDanger = $danger || $variant === 'danger';
        // Mobile-first: larger touch targets on mobile, compact on desktop
        $classes = 'flex w-full items-center gap-3 px-4 py-3.5 sm:py-2.5 text-left text-sm transition-all cursor-pointer rounded-lg sm:rounded-none mx-1 sm:mx-0 active:scale-[0.98] sm:active:scale-100 ' .
                   ($isDanger
                       ? 'text-rose-400 hover:bg-rose-500/10 active:bg-rose-500/20'
                       : 'text-slate-300 hover:bg-white/5 hover:text-white active:bg-white/10');
        $iconClass = $icon ? (str_starts_with($icon, 'ph-') ? $icon : 'ph-' . $icon) : null;
    @endphp

    @if($href)
        <a href="{{ $href }}" {{ $attributes->merge(['class' => $classes]) }}>
            @if($iconClass)
                <div class="flex h-9 w-9 sm:h-auto sm:w-auto shrink-0 items-center justify-center rounded-lg bg-white/5 sm:bg-transparent">
                    <i class="ph-duotone {{ $iconClass }} text-lg {{ $isDanger ? 'text-rose-400' : 'text-slate-400 sm:text-current' }}"></i>
                </div>
            @endif
            <div class="flex-1 min-w-0">
                <span class="block truncate">{{ $slot }}</span>
                @if($description)
                    <span class="block text-xs text-slate-500 truncate sm:hidden">{{ $description }}</span>
                @endif
            </div>
            <i class="ph ph-caret-right text-slate-600 sm:hidden"></i>
        </a>
    @else
        <button type="button" {{ $attributes->merge(['class' => $classes]) }}>
            @if($iconClass)
                <div class="flex h-9 w-9 sm:h-auto sm:w-auto shrink-0 items-center justify-center rounded-lg bg-white/5 sm:bg-transparent">
                    <i class="ph-duotone {{ $iconClass }} text-lg {{ $isDanger ? 'text-rose-400' : 'text-slate-400 sm:text-current' }}"></i>
                </div>
            @endif
            <div class="flex-1 min-w-0 text-left">
                <span class="block truncate">{{ $slot }}</span>
                @if($description)
                    <span class="block text-xs text-slate-500 truncate sm:hidden">{{ $description }}</span>
                @endif
            </div>
        </button>
    @endif
@endif

