@props([
    'align' => 'right',
    'label' => null,
])

@php
    $alignClasses = [
        'left' => 'left-0',
        'right' => 'right-0',
    ];

    $alignClass = $alignClasses[$align] ?? $alignClasses['right'];
@endphp

<div
    x-data="{
        open: false,
        isMobile: window.innerWidth < 640,
        init() {
            window.addEventListener('resize', () => {
                this.isMobile = window.innerWidth < 640;
            });
        }
    }"
    @click.away="open = false"
    class="relative inline-flex"
>
    {{-- Trigger Button --}}
    <button
        @click="open = !open"
        class="flex h-10 w-10 items-center justify-center rounded-xl text-slate-500 transition-all hover:bg-white/5 hover:text-white active:scale-95"
        aria-haspopup="true"
        :aria-expanded="open"
    >
        <i class="ph-bold ph-dots-three-vertical text-lg"></i>
    </button>

    {{-- Mobile backdrop --}}
    <template x-if="isMobile">
        <div
            x-show="open"
            x-transition:enter="ease-out duration-200"
            x-transition:enter-start="opacity-0"
            x-transition:enter-end="opacity-100"
            x-transition:leave="ease-in duration-150"
            x-transition:leave-start="opacity-100"
            x-transition:leave-end="opacity-0"
            @click="open = false"
            class="fixed inset-0 z-40 bg-black/60 backdrop-blur-sm"
        ></div>
    </template>

    {{-- Desktop dropdown / Mobile bottom sheet --}}
    <div
        x-show="open"
        x-transition:enter="transition ease-out duration-150"
        x-transition:enter-start="opacity-0 sm:scale-95"
        x-transition:enter-end="opacity-100 sm:scale-100"
        x-transition:leave="transition ease-in duration-100"
        x-transition:leave-start="opacity-100 sm:scale-100"
        x-transition:leave-end="opacity-0 sm:scale-95"
        :class="isMobile ? 'fixed inset-x-0 bottom-0 z-50 rounded-t-2xl' : 'absolute {{ $alignClass }} top-full z-50 mt-2 min-w-48 rounded-xl'"
        class="overflow-hidden border border-white/10 bg-[#1a1a24] shadow-2xl shadow-black/50"
        @click="open = false"
    >
        {{-- Mobile swipe indicator --}}
        <div class="flex justify-center pt-3 pb-1 sm:hidden">
            <div class="h-1 w-10 rounded-full bg-white/20"></div>
        </div>

        {{-- Mobile header with label --}}
        @if($label)
            <div class="px-4 py-3 border-b border-white/5 sm:hidden">
                <p class="text-sm font-medium text-slate-400">{{ $label }}</p>
            </div>
        @endif

        {{-- Menu items --}}
        <div class="py-2 px-1 sm:px-0 max-h-[60vh] sm:max-h-none overflow-y-auto pb-safe">
            {{ $slot }}
        </div>

        {{-- Mobile cancel button --}}
        <div class="p-3 border-t border-white/5 sm:hidden">
            <button
                @click="open = false"
                class="flex w-full items-center justify-center gap-2 rounded-xl bg-white/5 px-4 py-3 text-sm font-medium text-slate-300 hover:bg-white/10 active:scale-[0.98] transition-all"
            >
                @lang('Cancel')
            </button>
        </div>
    </div>
</div>

