@props([
    'type' => 'info',
    'title' => null,
    'dismissible' => false,
    'icon' => null
])

@php
    $types = [
        'info' => [
            'bg' => 'bg-sky-500/10',
            'border' => 'border-sky-500/20',
            'icon' => 'ph-info',
            'iconColor' => 'text-sky-400',
            'title' => 'text-sky-300',
            'text' => 'text-sky-400/80',
        ],
        'success' => [
            'bg' => 'bg-emerald-500/10',
            'border' => 'border-emerald-500/20',
            'icon' => 'ph-check-circle',
            'iconColor' => 'text-emerald-400',
            'title' => 'text-emerald-300',
            'text' => 'text-emerald-400/80',
        ],
        'warning' => [
            'bg' => 'bg-amber-500/10',
            'border' => 'border-amber-500/20',
            'icon' => 'ph-warning',
            'iconColor' => 'text-amber-400',
            'title' => 'text-amber-300',
            'text' => 'text-amber-400/80',
        ],
        'danger' => [
            'bg' => 'bg-rose-500/10',
            'border' => 'border-rose-500/20',
            'icon' => 'ph-x-circle',
            'iconColor' => 'text-rose-400',
            'title' => 'text-rose-300',
            'text' => 'text-rose-400/80',
        ],
    ];

    $config = $types[$type] ?? $types['info'];
    $iconClass = $icon ?? $config['icon'];
@endphp

<div
    x-data="{ show: true }"
    x-show="show"
    x-transition:leave="transition ease-in duration-200"
    x-transition:leave-start="opacity-100 translate-y-0"
    x-transition:leave-end="opacity-0 -translate-y-2"
    {{ $attributes->merge(['class' => "rounded-lg sm:rounded-xl border p-3 sm:p-4 {$config['bg']} {$config['border']}"]) }}
>
    <div class="flex gap-2.5 sm:gap-3">
        <i class="ph-duotone {{ $iconClass }} shrink-0 text-lg sm:text-xl {{ $config['iconColor'] }}"></i>

        <div class="min-w-0 flex-1">
            @if($title)
                <h4 class="text-sm sm:text-base font-semibold {{ $config['title'] }}">{{ $title }}</h4>
            @endif
            <div @class([
                'text-xs sm:text-sm',
                $config['text'],
                'mt-0.5 sm:mt-1' => $title
            ])>
                {{ $slot }}
            </div>
        </div>

        @if($dismissible)
            <button
                @click="show = false"
                class="shrink-0 rounded-lg p-1.5 sm:p-1 {{ $config['text'] }} transition-colors hover:bg-white/10 min-h-8 min-w-8 sm:min-h-0 sm:min-w-0 flex items-center justify-center"
            >
                <i class="ph-bold ph-x text-base sm:text-lg"></i>
            </button>
        @endif
    </div>
</div>

