@props([
    'name' => '',
    'src' => null,
    'size' => 'md',
    'status' => null
])

@php
    $sizes = [
        'xs' => 'h-6 w-6 text-2xs',
        'sm' => 'h-8 w-8 text-xs',
        'md' => 'h-10 w-10 text-sm',
        'lg' => 'h-12 w-12 text-base',
        'xl' => 'h-16 w-16 text-lg',
        '2xl' => 'h-20 w-20 text-xl',
    ];

    $statusSizes = [
        'xs' => 'h-1.5 w-1.5',
        'sm' => 'h-2 w-2',
        'md' => 'h-2.5 w-2.5',
        'lg' => 'h-3 w-3',
        'xl' => 'h-3.5 w-3.5',
        '2xl' => 'h-4 w-4',
    ];

    $statusColors = [
        'online' => 'bg-emerald-500',
        'offline' => 'bg-slate-500',
        'away' => 'bg-amber-500',
        'busy' => 'bg-rose-500',
    ];

    $sizeClass = $sizes[$size] ?? $sizes['md'];
    $statusSizeClass = $statusSizes[$size] ?? $statusSizes['md'];
    $statusColor = $status ? ($statusColors[$status] ?? $statusColors['offline']) : null;

    // Generate initials from name
    $initials = collect(explode(' ', $name))
        ->map(fn($word) => strtoupper(substr($word, 0, 1)))
        ->take(2)
        ->join('');

    // Generate consistent background color from name
    $colors = [
        'bg-indigo-500/20 text-indigo-400',
        'bg-emerald-500/20 text-emerald-400',
        'bg-amber-500/20 text-amber-400',
        'bg-rose-500/20 text-rose-400',
        'bg-sky-500/20 text-sky-400',
    ];
    $colorIndex = abs(crc32($name)) % count($colors);
    $bgColor = $colors[$colorIndex];
@endphp

<div {{ $attributes->merge(['class' => 'relative inline-flex']) }}>
    @if($src)
        <img
            src="{{ $src }}"
            alt="{{ $name }}"
            class="{{ $sizeClass }} rounded-full object-cover ring-2 ring-[#12121a]"
        >
    @else
        <div class="{{ $sizeClass }} {{ $bgColor }} flex items-center justify-center rounded-full font-semibold ring-2 ring-[#12121a]">
            {{ $initials ?: '?' }}
        </div>
    @endif

    @if($status)
        <span class="absolute bottom-0 right-0 {{ $statusSizeClass }} {{ $statusColor }} rounded-full ring-2 ring-[#12121a]"></span>
    @endif
</div>

