@props([
    'type' => 'primary',
    'size' => 'default',
    'dot' => false,
    'pulse' => false
])

@php
    $types = [
        'primary' => 'bg-indigo-500/15 text-indigo-400',
        'success' => 'bg-emerald-500/15 text-emerald-400',
        'warning' => 'bg-amber-500/15 text-amber-400',
        'danger' => 'bg-rose-500/15 text-rose-400',
        'info' => 'bg-sky-500/15 text-sky-400',
        'neutral' => 'bg-slate-500/15 text-slate-400',
    ];

    $sizes = [
        'sm' => 'text-[10px] px-2 py-0.5',
        'default' => 'text-[11px] px-2.5 py-1',
        'lg' => 'text-xs px-3 py-1.5',
    ];

    $typeClass = $types[$type] ?? $types['primary'];
    $sizeClass = $sizes[$size] ?? $sizes['default'];

    $baseClasses = 'inline-flex items-center gap-1.5 rounded-lg font-semibold';

    $classes = "{$baseClasses} {$typeClass} {$sizeClass}";
@endphp

<span {{ $attributes->merge(['class' => $classes]) }}>
    @if($dot)
        <span @class([
            'h-1.5 w-1.5 rounded-full',
            'bg-indigo-400' => $type === 'primary',
            'bg-emerald-400' => $type === 'success',
            'bg-amber-400' => $type === 'warning',
            'bg-rose-400' => $type === 'danger',
            'bg-sky-400' => $type === 'info',
            'bg-slate-400' => $type === 'neutral',
            'animate-pulse' => $pulse,
        ])></span>
    @endif
    {{ $slot }}
</span>

