@props([
    'href' => null,
    'active' => false,
    'icon' => null,
    'hideOnMobile' => false
])

<div @class([
    'flex items-center gap-1.5 sm:gap-2 min-w-0',
    'hidden sm:flex' => $hideOnMobile,
])>
    <i class="ph-bold ph-caret-right text-[10px] sm:text-xs text-slate-600 shrink-0"></i>

    @if($href && !$active)
        <a
            href="{{ $href }}"
            wire:navigate
            class="text-xs sm:text-sm text-slate-500 transition-colors hover:text-white truncate max-w-[80px] sm:max-w-[120px] min-h-6 sm:min-h-0 flex items-center"
        >
            @if($icon)
                <i class="ph-duotone {{ $icon }} text-sm sm:hidden"></i>
                <span class="hidden sm:inline">{{ $slot }}</span>
            @else
                {{ $slot }}
            @endif
        </a>
    @else
        <span @class([
            'text-xs sm:text-sm truncate max-w-[100px] sm:max-w-[200px]',
            'font-medium' => $active,
            'text-white' => $active,
            'text-slate-500' => !$active
        ])>
            {{ $slot }}
        </span>
    @endif
</div>

