@props([
    'type' => 'button',
    'variant' => 'primary',
    'size' => 'default',
    'icon' => null,
    'iconPosition' => 'left',
    'loading' => false,
    'disabled' => false,
    'href' => null,
    'wireLoading' => null,
    'fullWidth' => false,
])

@php
    // Base classes with mobile-first touch optimization
    $baseClasses = 'inline-flex items-center justify-center gap-2 rounded-xl font-semibold transition-all duration-200 cursor-pointer focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-offset-[#0a0a0f] disabled:cursor-not-allowed disabled:opacity-50 active:scale-[0.98] select-none';

    $variants = [
        'primary' => 'bg-gradient-to-r from-indigo-500 to-purple-500 text-white shadow-lg shadow-indigo-500/25 hover:shadow-indigo-500/40 hover:from-indigo-600 hover:to-purple-600 focus:ring-indigo-500/50',
        'secondary' => 'bg-white/5 text-slate-300 ring-1 ring-white/10 hover:bg-white/10 hover:text-white focus:ring-white/20',
        'danger' => 'bg-gradient-to-r from-rose-500 to-pink-500 text-white shadow-lg shadow-rose-500/25 hover:shadow-rose-500/40 hover:from-rose-600 hover:to-pink-600 focus:ring-rose-500/50',
        'success' => 'bg-gradient-to-r from-emerald-500 to-teal-500 text-white shadow-lg shadow-emerald-500/25 hover:shadow-emerald-500/40 hover:from-emerald-600 hover:to-teal-600 focus:ring-emerald-500/50',
        'warning' => 'bg-gradient-to-r from-amber-500 to-orange-500 text-white shadow-lg shadow-amber-500/25 hover:shadow-amber-500/40 hover:from-amber-600 hover:to-orange-600 focus:ring-amber-500/50',
        'ghost' => 'bg-transparent text-slate-400 hover:bg-white/5 hover:text-white focus:ring-white/20',
        'outline' => 'border border-white/10 bg-transparent text-slate-300 hover:bg-white/5 hover:border-white/20 hover:text-white focus:ring-white/20',
    ];

    // Mobile-first sizing with minimum 44px touch targets
    $sizes = [
        'xs' => 'px-3 py-2 text-xs min-h-[36px]',
        'sm' => 'px-3.5 py-2.5 text-sm min-h-[40px]',
        'default' => 'px-5 py-3 text-sm min-h-[44px]',
        'lg' => 'px-6 py-3.5 text-base min-h-[48px]',
    ];

    $variantClass = $variants[$variant] ?? $variants['primary'];
    $sizeClass = $sizes[$size] ?? $sizes['default'];
    $widthClass = $fullWidth ? 'w-full' : '';

    $classes = "{$baseClasses} {$variantClass} {$sizeClass} {$widthClass}";

    // Icon-only button gets square padding
    if ($icon && !$slot->isNotEmpty()) {
        $classes .= ' !px-3 aspect-square';
    }
@endphp

@if($href)
    <a
        href="{{ $href }}"
        {{ $attributes->merge(['class' => $classes]) }}
        @if($disabled) aria-disabled="true" tabindex="-1" @endif
    >
        @if($icon && $iconPosition === 'left' && !$loading)
            <i class="ph-duotone {{ $icon }} text-lg"></i>
        @endif

        {{ $slot }}

        @if($icon && $iconPosition === 'right' && !$loading)
            <i class="ph-duotone {{ $icon }} text-lg"></i>
        @endif
    </a>
@else
    <button
        type="{{ $type }}"
        {{ $attributes->merge(['class' => $classes]) }}
        @if($disabled || $loading) disabled @endif
        @if($wireLoading)
            wire:loading.class="opacity-75 cursor-wait"
            wire:loading.attr="disabled"
            wire:target="{{ $wireLoading }}"
        @endif
    >
        {{-- Loading spinner (shown during Livewire action) --}}
        @if($wireLoading)
            <span wire:loading wire:target="{{ $wireLoading }}" class="absolute inset-0 flex items-center justify-center">
                <i class="ph-bold ph-spinner-gap animate-spin text-lg"></i>
            </span>
            <span wire:loading.class="invisible" wire:target="{{ $wireLoading }}" class="inline-flex items-center gap-2">
        @endif

        @if($loading)
            <i class="ph-bold ph-spinner-gap animate-spin text-lg"></i>
        @elseif($icon && $iconPosition === 'left')
            <i class="ph-duotone {{ $icon }} text-lg"></i>
        @endif

        {{ $slot }}

        @if($icon && $iconPosition === 'right' && !$loading)
            <i class="ph-duotone {{ $icon }} text-lg"></i>
        @endif

        @if($wireLoading)
            </span>
        @endif
    </button>
@endif

