@props([
    'title' => null,
    'subtitle' => null,
    'actions' => null,
    'border' => true,
])

<div {{ $attributes->merge(['class' => 'flex flex-wrap items-center justify-between gap-4 px-6 py-4' . ($border ? ' border-b border-white/5' : '')]) }}>
    <div class="flex-1 min-w-0">
        @if($title)
            <h3 class="text-lg font-semibold text-white truncate">{{ $title }}</h3>
        @endif
        @if($subtitle)
            <p class="mt-1 text-sm text-slate-400">{{ $subtitle }}</p>
        @endif
        {{ $slot }}
    </div>
    
    @if($actions ?? null)
        <div class="flex items-center gap-3 flex-shrink-0">
            {{ $actions }}
        </div>
    @endif
</div>

