@props([
    'title' => null,
    'subtitle' => null,
    'padding' => true,
    'headerPadding' => true,
    'footer' => false,
    'collapsible' => false,
    'collapsed' => false,
    'icon' => null,
])

<div
    {{ $attributes->merge(['class' => 'overflow-hidden rounded-xl sm:rounded-2xl border border-white/5 bg-[#12121a] shadow-xl shadow-black/10']) }}
    @if($collapsible)
        x-data="{ collapsed: {{ $collapsed ? 'true' : 'false' }} }"
    @endif
>
    @if($title || isset($header))
        <div
            @class([
                'flex flex-col sm:flex-row sm:items-center justify-between gap-3 sm:gap-4 border-b border-white/5 px-4 sm:px-6 py-4 sm:py-5',
                'px-0' => !$headerPadding,
                'cursor-pointer hover:bg-white/[0.02] transition-colors' => $collapsible,
            ])
            @if($collapsible) @click="collapsed = !collapsed" @endif
        >
            <div class="flex items-center gap-3 min-w-0 flex-1">
                @if($icon)
                    <div class="flex h-10 w-10 shrink-0 items-center justify-center rounded-xl bg-white/5">
                        <i class="ph-duotone {{ $icon }} text-xl text-slate-400"></i>
                    </div>
                @endif
                <div class="min-w-0 flex-1">
                    @if($title)
                        <h3 class="text-sm sm:text-[15px] font-semibold text-white truncate">{{ $title }}</h3>
                    @endif
                    @if($subtitle)
                        <p class="mt-0.5 sm:mt-1 text-xs sm:text-sm text-slate-400 line-clamp-2">{{ $subtitle }}</p>
                    @endif
                </div>
            </div>

            <div class="flex items-center gap-2 shrink-0">
                @if(isset($actions))
                    {{ $actions }}
                @endif

                @if($collapsible)
                    <button
                        type="button"
                        class="flex h-8 w-8 items-center justify-center rounded-lg text-slate-500 hover:bg-white/5 hover:text-white transition-colors"
                        @click.stop="collapsed = !collapsed"
                    >
                        <i class="ph-bold ph-caret-down text-sm transition-transform duration-200" :class="collapsed ? '-rotate-90' : ''"></i>
                    </button>
                @endif
            </div>

            @if(isset($header))
                {{ $header }}
            @endif
        </div>
    @endif

    <div
        @class(['p-4 sm:p-6' => $padding, 'p-0' => !$padding])
        @if($collapsible)
            x-show="!collapsed"
            x-transition:enter="transition ease-out duration-200"
            x-transition:enter-start="opacity-0 -translate-y-2"
            x-transition:enter-end="opacity-100 translate-y-0"
            x-transition:leave="transition ease-in duration-150"
            x-transition:leave-start="opacity-100 translate-y-0"
            x-transition:leave-end="opacity-0 -translate-y-2"
        @endif
    >
        {{ $slot }}
    </div>

    @if(isset($footer) && $footer !== false)
        <div
            class="border-t border-white/5 bg-white/[0.02] px-4 sm:px-6 py-3 sm:py-4"
            @if($collapsible) x-show="!collapsed" @endif
        >
            {{ $footer }}
        </div>
    @endif
</div>

