@props([
    'id' => null,
    'type' => 'line',
    'height' => 300,
    'mobileHeight' => 200,
    'labels' => [],
    'datasets' => [],
    'title' => null,
    'subtitle' => null,
])

@php
    $chartId = $id ?? 'chart_' . uniqid();
    $chartConfig = [
        'type' => $type,
        'data' => [
            'labels' => $labels,
            'datasets' => $datasets,
        ],
        'options' => [
            'responsive' => true,
            'maintainAspectRatio' => false,
            'interaction' => [
                'mode' => 'index',
                'intersect' => false,
            ],
            'plugins' => [
                'legend' => [
                    'display' => count($datasets) > 1,
                    'position' => 'bottom',
                    'labels' => [
                        'color' => '#94a3b8',
                        'padding' => 16,
                        'boxWidth' => 12,
                        'boxHeight' => 12,
                        'font' => ['size' => 11],
                    ],
                ],
                'tooltip' => [
                    'backgroundColor' => 'rgba(26, 26, 36, 0.95)',
                    'titleColor' => '#fff',
                    'bodyColor' => '#94a3b8',
                    'borderColor' => 'rgba(255,255,255,0.1)',
                    'borderWidth' => 1,
                    'padding' => 12,
                    'cornerRadius' => 8,
                ],
            ],
            'scales' => [
                'x' => [
                    'grid' => ['display' => false],
                    'ticks' => [
                        'color' => '#64748b',
                        'maxRotation' => 0,
                        'autoSkip' => true,
                        'maxTicksLimit' => 7,
                    ],
                ],
                'y' => [
                    'beginAtZero' => true,
                    'grid' => ['color' => 'rgba(255,255,255,0.05)'],
                    'ticks' => [
                        'color' => '#64748b',
                        'maxTicksLimit' => 5,
                    ],
                ],
            ],
        ],
    ];
@endphp

<div
    {{ $attributes->merge(['class' => '']) }}
    x-data="{ isMobile: window.innerWidth < 640 }"
    x-init="window.addEventListener('resize', () => isMobile = window.innerWidth < 640)"
>
    @if($title)
        <div class="mb-3 sm:mb-4 flex flex-col sm:flex-row sm:items-center justify-between gap-2">
            <div>
                <h3 class="text-base sm:text-lg font-semibold text-white">{{ $title }}</h3>
                @if($subtitle)
                    <p class="text-xs sm:text-sm text-slate-400">{{ $subtitle }}</p>
                @endif
            </div>

            @if(isset($actions))
                <div class="flex items-center gap-2">
                    {{ $actions }}
                </div>
            @endif
        </div>
    @endif

    <div
        class="relative"
        :style="isMobile ? 'height: {{ $mobileHeight }}px' : 'height: {{ $height }}px'"
    >
        <canvas id="{{ $chartId }}" wire:ignore></canvas>
    </div>
</div>

@pushOnce('scripts')
<script src="https://cdn.jsdelivr.net/npm/chart.js@4.4.1/dist/chart.umd.min.js"></script>
@endPushOnce

@push('scripts')
<script>
    document.addEventListener('DOMContentLoaded', function() {
        const ctx = document.getElementById('{{ $chartId }}');
        if (ctx && typeof Chart !== 'undefined') {
            const config = @json($chartConfig);
            const isMobile = window.innerWidth < 640;

            // Mobile optimizations
            if (isMobile) {
                if (config.options.plugins.legend) {
                    config.options.plugins.legend.labels.padding = 10;
                    config.options.plugins.legend.labels.boxWidth = 10;
                    config.options.plugins.legend.labels.font = { size: 10 };
                }
                if (config.options.scales.x) {
                    config.options.scales.x.ticks.maxTicksLimit = 5;
                    config.options.scales.x.ticks.font = { size: 10 };
                }
                if (config.options.scales.y) {
                    config.options.scales.y.ticks.maxTicksLimit = 4;
                    config.options.scales.y.ticks.font = { size: 10 };
                }
            }

            // Dark theme colors
            if (config.options && config.options.scales) {
                if (config.options.scales.y) {
                    config.options.scales.y.grid.color = 'rgba(255,255,255,0.05)';
                    config.options.scales.y.ticks.color = '#64748b';
                }
                if (config.options.scales.x) {
                    config.options.scales.x.ticks.color = '#64748b';
                }
            }

            new Chart(ctx, config);
        }
    });
</script>
@endpush

