@props([
    'label' => null,
    'name' => null,
    'id' => null,
    'value' => '1',
    'checked' => false,
    'helper' => null,
    'error' => null,
    'disabled' => false
])

@php
    $inputId = $id ?? $name ?? uniqid('checkbox_');
    $hasError = $error || (isset($errors) && $name && $errors->has($name));
    $errorMessage = $error ?? ($name ? $errors->first($name) : null);
@endphp

<div {{ $attributes->only('class') }}>
    <label class="flex cursor-pointer items-start gap-3">
        <input
            type="checkbox"
            id="{{ $inputId }}"
            @if($name) name="{{ $name }}" wire:model="{{ $name }}" @endif
            value="{{ $value }}"
            @checked($checked)
            @disabled($disabled)
            {{ $attributes->except('class') }}
            @class([
                'mt-0.5 h-4 w-4 rounded border-white/20 bg-white/5 text-indigo-500 transition-colors focus:ring-2 focus:ring-indigo-500/20 checked:border-indigo-500 checked:bg-indigo-500',
                'cursor-not-allowed opacity-50' => $disabled,
                'border-rose-500/50' => $hasError
            ])
        >

        <div class="flex-1">
            @if($label)
                <span @class([
                    'text-sm font-medium',
                    'text-slate-300' => !$disabled,
                    'text-slate-500' => $disabled
                ])>
                    {{ $label }}
                </span>
            @endif

            @if($helper && !$hasError)
                <p class="mt-0.5 text-xs text-slate-500">{{ $helper }}</p>
            @endif

            @if($hasError)
                <p class="mt-0.5 text-xs text-rose-400">{{ $errorMessage }}</p>
            @endif
        </div>
    </label>
</div>

