@props([
    'label' => null,
    'name' => null,
    'id' => null,
    'value' => '',
    'language' => 'html',
    'helper' => null,
    'error' => null,
    'required' => false,
    'disabled' => false,
    'rows' => 10
])

@php
    $inputId = $id ?? $name ?? uniqid('code_');
    $hasError = $error || (isset($errors) && $name && $errors->has($name));
    $errorMessage = $error ?? ($name ? $errors->first($name) : null);
@endphp

<div {{ $attributes->only('class')->merge(['class' => 'space-y-1']) }}>
    @if($label)
        <div class="flex items-center justify-between">
            <label for="{{ $inputId }}" @class(['label', 'label-required' => $required])>
                {{ $label }}
            </label>
            <span class="rounded-md bg-slate-100 px-2 py-0.5 text-xs font-medium text-slate-600">
                {{ strtoupper($language) }}
            </span>
        </div>
    @endif
    
    <div @class([
        'relative overflow-hidden rounded-xl border',
        'border-slate-200' => !$hasError,
        'border-danger-500' => $hasError
    ])>
        <div class="flex items-center justify-between border-b border-slate-200 bg-slate-50 px-3 py-2">
            <div class="flex items-center gap-1.5">
                <span class="h-3 w-3 rounded-full bg-danger-400"></span>
                <span class="h-3 w-3 rounded-full bg-warning-400"></span>
                <span class="h-3 w-3 rounded-full bg-success-400"></span>
            </div>
            <button 
                type="button"
                onclick="navigator.clipboard.writeText(document.getElementById('{{ $inputId }}').value)"
                class="flex items-center gap-1 text-xs text-slate-500 transition-colors hover:text-slate-700"
            >
                <i class="ph-duotone ph-copy"></i>
                Copy
            </button>
        </div>
        
        <textarea 
            id="{{ $inputId }}"
            @if($name) name="{{ $name }}" wire:model="{{ $name }}" @endif
            rows="{{ $rows }}"
            @required($required)
            @disabled($disabled)
            {{ $attributes->except('class') }}
            class="w-full resize-none border-0 bg-slate-900 p-4 font-mono text-sm text-slate-100 placeholder-slate-500 focus:outline-none focus:ring-0"
        >{{ $value }}</textarea>
    </div>
    
    @if($helper && !$hasError)
        <p class="helper-text">{{ $helper }}</p>
    @endif
    
    @if($hasError)
        <p class="error-text">{{ $errorMessage }}</p>
    @endif
</div>

