@props([
    'label' => null,
    'name' => null,
    'id' => null,
    'value' => '#6366f1',
    'helper' => null,
    'error' => null,
    'required' => false,
    'disabled' => false,
    'presets' => null
])

@php
    $inputId = $id ?? $name ?? uniqid('color_');
    $hasError = $error || (isset($errors) && $name && $errors->has($name));
    $errorMessage = $error ?? ($name ? $errors->first($name) : null);
    
    $defaultPresets = [
        '#6366f1', '#8b5cf6', '#ec4899', '#ef4444', 
        '#f97316', '#eab308', '#22c55e', '#14b8a6',
        '#06b6d4', '#3b82f6', '#64748b', '#1e293b'
    ];
    
    $colorPresets = $presets ?? $defaultPresets;
@endphp

<div 
    x-data="{ color: '{{ $value }}' }"
    {{ $attributes->only('class')->merge(['class' => 'space-y-1']) }}
>
    @if($label)
        <label for="{{ $inputId }}" @class(['label', 'label-required' => $required])>
            {{ $label }}
        </label>
    @endif
    
    <div class="flex items-center gap-3">
        <div class="relative">
            <input 
                type="color"
                id="{{ $inputId }}"
                @if($name) name="{{ $name }}" wire:model="{{ $name }}" @endif
                x-model="color"
                @required($required)
                @disabled($disabled)
                class="h-10 w-14 cursor-pointer rounded-lg border border-slate-200 p-1"
            >
        </div>
        
        <input 
            type="text"
            x-model="color"
            @disabled($disabled)
            @class([
                'input w-28 font-mono text-sm uppercase',
                'input-error' => $hasError,
                'cursor-not-allowed opacity-50' => $disabled
            ])
        >
    </div>
    
    @if($colorPresets)
        <div class="mt-2 flex flex-wrap gap-1.5">
            @foreach($colorPresets as $preset)
                <button 
                    type="button"
                    @click="color = '{{ $preset }}'"
                    class="h-6 w-6 rounded-md border border-slate-200 transition-transform hover:scale-110 focus:outline-none focus:ring-2 focus:ring-primary-500/50"
                    style="background-color: {{ $preset }}"
                    title="{{ $preset }}"
                ></button>
            @endforeach
        </div>
    @endif
    
    @if($helper && !$hasError)
        <p class="helper-text">{{ $helper }}</p>
    @endif
    
    @if($hasError)
        <p class="error-text">{{ $errorMessage }}</p>
    @endif
</div>

