@props([
    'name' => 'confirm',
    'title' => null,
    'description' => null,
    'icon' => 'ph-warning-circle',
    'iconColor' => 'danger',
    'confirmText' => null,
    'cancelText' => null,
    'confirmVariant' => 'danger'
])

@php
    $iconColors = [
        'primary' => 'bg-indigo-500/15 text-indigo-400',
        'success' => 'bg-emerald-500/15 text-emerald-400',
        'warning' => 'bg-amber-500/15 text-amber-400',
        'danger' => 'bg-rose-500/15 text-rose-400',
        'info' => 'bg-sky-500/15 text-sky-400',
    ];

    $iconColorClass = $iconColors[$iconColor] ?? $iconColors['danger'];
    $title = $title ?? __('Are you sure?');
    $description = $description ?? __('This action cannot be undone.');
    $confirmText = $confirmText ?? __('Confirm');
    $cancelText = $cancelText ?? __('Cancel');
@endphp

<x-admin.modal :name="$name" maxWidth="sm">
    <div class="p-6 text-center">
        <!-- Icon -->
        <div class="mx-auto mb-4 flex h-16 w-16 items-center justify-center rounded-full {{ $iconColorClass }}">
            <i class="ph-duotone {{ $icon }} text-3xl"></i>
        </div>

        <!-- Title -->
        <h3 class="text-lg font-semibold text-white">{{ $title }}</h3>

        <!-- Description -->
        <p class="mt-2 text-sm text-slate-400">{{ $description }}</p>

        <!-- Custom content slot -->
        @if($slot->isNotEmpty())
            <div class="mt-4">
                {{ $slot }}
            </div>
        @endif

        <!-- Actions -->
        <div class="mt-6 flex justify-center gap-3">
            <x-admin.button
                variant="secondary"
                @click="$dispatch('close-modal', '{{ $name }}')"
            >
                {{ $cancelText }}
            </x-admin.button>

            <x-admin.button
                :variant="$confirmVariant"
                {{ $attributes->filter(fn ($value, $key) => str_starts_with($key, 'wire:') || str_starts_with($key, '@')) }}
            >
                {{ $confirmText }}
            </x-admin.button>
        </div>
    </div>
</x-admin.modal>

