@props([
    'text' => '',
    'tooltip' => 'Copy to clipboard'
])

<button 
    x-data="{ copied: false }"
    @click="
        navigator.clipboard.writeText('{{ $text }}');
        copied = true;
        setTimeout(() => copied = false, 2000);
    "
    {{ $attributes->merge(['class' => 'inline-flex items-center gap-1.5 rounded-lg px-2 py-1 text-xs font-medium text-slate-600 transition-colors hover:bg-slate-100']) }}
>
    <span class="font-mono">{{ Str::limit($text, 20) }}</span>
    <i 
        class="ph-duotone text-sm transition-all"
        :class="copied ? 'ph-check text-success-600' : 'ph-copy'"
    ></i>
</button>

