@props([
    'headers' => [],
    'striped' => false,
    'hoverable' => true,
    'loading' => false,
    'emptyMessage' => 'No data available',
    'emptyIcon' => 'ph-database',
    'mobileCardView' => false,
])

<div {{ $attributes->merge(['class' => 'overflow-hidden rounded-xl sm:rounded-2xl border border-white/5 bg-[#12121a]']) }}>
    <!-- Table Header Actions -->
    @if(isset($actions))
        <div class="flex flex-col sm:flex-row sm:flex-wrap items-stretch sm:items-center justify-between gap-3 sm:gap-4 border-b border-white/5 p-4 sm:p-5">
            {{ $actions }}
        </div>
    @endif

    <!-- Table Container with scroll indicator -->
    <div class="relative">
        {{-- Scroll indicator for mobile --}}
        <div class="absolute right-0 top-0 bottom-0 w-8 bg-gradient-to-l from-[#12121a] to-transparent pointer-events-none z-10 sm:hidden opacity-50"></div>

        <div class="overflow-x-auto scrollbar-thin">
            <table class="w-full min-w-[600px] sm:min-w-0">
                <thead>
                    <tr class="border-b border-white/5 bg-white/[0.02]">
                        @foreach($headers as $key => $header)
                            @php
                                $hiddenOnMobile = isset($header['hideOnMobile']) && $header['hideOnMobile'];
                            @endphp
                            <th
                                class="px-3 sm:px-5 py-3 sm:py-4 text-left text-[10px] sm:text-xs font-semibold uppercase tracking-wider text-slate-400 whitespace-nowrap {{ $hiddenOnMobile ? 'hidden sm:table-cell' : '' }}"
                                @if(isset($header['width'])) style="width: {{ $header['width'] }}" @endif
                            >
                                @if(isset($header['sortable']) && $header['sortable'])
                                    <button class="flex items-center gap-1.5 transition-colors hover:text-white min-h-[28px]">
                                        {{ $header['label'] ?? $header }}
                                        <i class="ph-bold ph-arrows-down-up text-[10px]"></i>
                                    </button>
                                @else
                                    {{ $header['label'] ?? $header }}
                                @endif
                            </th>
                        @endforeach
                    </tr>
                </thead>
                <tbody class="divide-y divide-white/5">
                    @if($loading)
                        @for($i = 0; $i < 5; $i++)
                            <tr class="animate-pulse">
                                @foreach($headers as $header)
                                    <td class="px-3 sm:px-5 py-3 sm:py-4">
                                        <div class="h-4 w-3/4 rounded-lg bg-white/5"></div>
                                    </td>
                                @endforeach
                            </tr>
                        @endfor
                    @else
                        {{ $slot }}
                    @endif
                </tbody>
            </table>
        </div>

        <!-- Empty State -->
        @if(!$loading && empty(trim($slot->toHtml())))
            <div class="flex flex-col items-center justify-center py-12 sm:py-16 px-4 text-center">
                <div class="mb-3 sm:mb-4 flex h-14 w-14 sm:h-16 sm:w-16 items-center justify-center rounded-xl sm:rounded-2xl bg-white/5 text-slate-500">
                    <i class="ph-duotone {{ $emptyIcon }} text-2xl sm:text-3xl"></i>
                </div>
                <p class="text-sm font-medium text-slate-400">{{ $emptyMessage }}</p>
                @if(isset($emptyAction))
                    <div class="mt-4">
                        {{ $emptyAction }}
                    </div>
                @endif
            </div>
        @endif
    </div>

    <!-- Pagination -->
    @if(isset($pagination))
        <div class="border-t border-white/5 px-3 sm:px-5 py-3 sm:py-4">
            {{ $pagination }}
        </div>
    @endif
</div>

