@props([
    'label' => null,
    'name' => null,
    'id' => null,
    'value' => null,
    'placeholder' => 'Select date',
    'helper' => null,
    'error' => null,
    'required' => false,
    'disabled' => false,
    'min' => null,
    'max' => null,
    'type' => 'date' // date, datetime-local, time
])

@php
    $inputId = $id ?? $name ?? uniqid('date_');
    $hasError = $error || (isset($errors) && $name && $errors->has($name));
    $errorMessage = $error ?? ($name ? $errors->first($name) : null);
@endphp

<div {{ $attributes->only('class')->merge(['class' => 'space-y-1']) }}>
    @if($label)
        <label for="{{ $inputId }}" @class(['label', 'label-required' => $required])>
            {{ $label }}
        </label>
    @endif
    
    <div class="relative">
        <div class="pointer-events-none absolute inset-y-0 left-0 flex items-center pl-3">
            <i class="ph-duotone {{ $type === 'time' ? 'ph-clock' : 'ph-calendar' }} text-lg text-slate-400"></i>
        </div>
        
        <input 
            type="{{ $type }}"
            id="{{ $inputId }}"
            @if($name) name="{{ $name }}" wire:model="{{ $name }}" @endif
            value="{{ $value }}"
            placeholder="{{ $placeholder }}"
            @if($min) min="{{ $min }}" @endif
            @if($max) max="{{ $max }}" @endif
            @required($required)
            @disabled($disabled)
            {{ $attributes->except('class') }}
            @class([
                'input pl-10',
                'input-error' => $hasError,
                'cursor-not-allowed opacity-50' => $disabled
            ])
        >
    </div>
    
    @if($helper && !$hasError)
        <p class="helper-text">{{ $helper }}</p>
    @endif
    
    @if($hasError)
        <p class="error-text">{{ $errorMessage }}</p>
    @endif
</div>

