@props([
    'label' => null,
    'position' => 'center',
    'spacing' => 'default'
])

@php
    $positions = [
        'left' => 'justify-start',
        'center' => 'justify-center',
        'right' => 'justify-end',
    ];

    $spacings = [
        'sm' => 'my-2 sm:my-3',
        'default' => 'my-3 sm:my-4',
        'lg' => 'my-4 sm:my-6',
    ];

    $positionClass = $positions[$position] ?? $positions['center'];
    $spacingClass = $spacings[$spacing] ?? $spacings['default'];
@endphp

@if($label)
    <div class="relative {{ $spacingClass }}">
        <div class="absolute inset-0 flex items-center" aria-hidden="true">
            <div class="w-full border-t border-white/10"></div>
        </div>
        <div class="relative flex {{ $positionClass }}">
            <span class="bg-[#12121a] px-2 sm:px-3 text-xs sm:text-sm text-slate-500">{{ $label }}</span>
        </div>
    </div>
@else
    <div {{ $attributes->merge(['class' => "border-t border-white/10 {$spacingClass}"]) }}></div>
@endif

