@props([
    'name' => 'drawer',
    'title' => null,
    'subtitle' => null,
    'width' => 'md',
    'position' => 'right',
    'icon' => null,
])

@php
    $widths = [
        'sm' => 'sm:max-w-sm',
        'md' => 'sm:max-w-md',
        'lg' => 'sm:max-w-lg',
        'xl' => 'sm:max-w-xl',
        '2xl' => 'sm:max-w-2xl',
        '3xl' => 'sm:max-w-3xl',
        'full' => 'sm:max-w-full',
    ];

    $widthClass = $widths[$width] ?? $widths['md'];

    $isRight = $position === 'right';
    $translateClass = $isRight ? 'translate-x-full' : '-translate-x-full';
    $positionClass = $isRight ? 'right-0' : 'left-0';
@endphp

<div
    x-data="{
        show: false,
        startY: 0,
        currentY: 0,
        dragging: false
    }"
    x-on:open-drawer.window="$event.detail === '{{ $name }}' && (show = true)"
    x-on:close-drawer.window="$event.detail === '{{ $name }}' && (show = false)"
    x-on:keydown.escape.window="show = false"
    x-init="$watch('show', value => { document.body.style.overflow = value ? 'hidden' : '' })"
    x-show="show"
    x-cloak
    class="fixed inset-0 z-50 overflow-hidden"
>
    <!-- Backdrop -->
    <div
        x-show="show"
        x-transition:enter="ease-out duration-300"
        x-transition:enter-start="opacity-0"
        x-transition:enter-end="opacity-100"
        x-transition:leave="ease-in duration-200"
        x-transition:leave-start="opacity-100"
        x-transition:leave-end="opacity-0"
        @click="show = false"
        class="absolute inset-0 bg-black/70 backdrop-blur-sm"
    ></div>

    <!-- Drawer Panel - Full width on mobile, positioned on desktop -->
    <div class="fixed inset-0 sm:inset-y-0 sm:inset-x-auto {{ $positionClass }} flex max-w-full">
        <div
            x-show="show"
            {{-- Mobile: slide up from bottom, Desktop: slide in from side --}}
            x-transition:enter="transform transition ease-out duration-300"
            x-transition:enter-start="translate-y-full sm:translate-y-0 sm:{{ $translateClass }}"
            x-transition:enter-end="translate-y-0 sm:translate-x-0"
            x-transition:leave="transform transition ease-in duration-200"
            x-transition:leave-start="translate-y-0 sm:translate-x-0"
            x-transition:leave-end="translate-y-full sm:translate-y-0 sm:{{ $translateClass }}"
            @touchstart.passive="startY = $event.touches[0].clientY; dragging = true"
            @touchmove.passive="if(dragging) currentY = $event.touches[0].clientY - startY"
            @touchend="if(currentY > 100) show = false; currentY = 0; dragging = false"
            :style="dragging && currentY > 0 ? 'transform: translateY(' + currentY + 'px)' : ''"
            class="w-screen {{ $widthClass }} flex flex-col h-[95vh] sm:h-full mt-auto sm:mt-0 rounded-t-2xl sm:rounded-none"
        >
            <div class="flex h-full flex-col border-l border-white/10 bg-[#0f0f15] shadow-2xl shadow-black/50 rounded-t-2xl sm:rounded-none overflow-hidden">
                {{-- Mobile swipe indicator --}}
                <div class="flex justify-center pt-3 pb-1 sm:hidden">
                    <div class="h-1 w-10 rounded-full bg-white/20"></div>
                </div>

                <!-- Header -->
                <div class="flex items-center justify-between border-b border-white/5 px-4 sm:px-6 py-4 sm:py-5 shrink-0">
                    <div class="flex items-center gap-3 min-w-0 flex-1">
                        @if($icon)
                            <div class="flex h-10 w-10 shrink-0 items-center justify-center rounded-xl bg-white/5">
                                <i class="ph-duotone {{ $icon }} text-xl text-indigo-400"></i>
                            </div>
                        @endif
                        <div class="min-w-0 flex-1">
                            @if($title)
                                <h2 class="text-base sm:text-lg font-semibold text-white truncate">{{ $title }}</h2>
                            @endif
                            @if($subtitle)
                                <p class="mt-0.5 text-xs sm:text-sm text-slate-400 truncate">{{ $subtitle }}</p>
                            @endif
                        </div>
                    </div>
                    <button
                        @click="show = false"
                        class="ml-3 flex h-10 w-10 shrink-0 items-center justify-center rounded-xl text-slate-500 transition-all hover:bg-white/5 hover:text-white active:scale-95"
                    >
                        <i class="ph-bold ph-x text-lg"></i>
                    </button>
                </div>

                <!-- Content -->
                <div class="flex-1 overflow-y-auto overscroll-contain p-4 sm:p-6">
                    {{ $slot }}
                </div>

                <!-- Footer -->
                @if(isset($footer))
                    <div class="border-t border-white/5 px-4 sm:px-6 py-3 sm:py-4 shrink-0 pb-safe flex flex-col-reverse sm:flex-row items-stretch sm:items-center justify-end gap-2 sm:gap-3">
                        {{ $footer }}
                    </div>
                @endif
            </div>
        </div>
    </div>
</div>

