@props([
    'align' => 'right',
    'width' => '48',
    'contentClasses' => 'py-2 bg-[#1a1a24]'
])

@php
    $alignmentClasses = [
        'left' => 'left-0',
        'right' => 'right-0',
        'center' => 'left-1/2 -translate-x-1/2',
    ];

    $widthClasses = [
        '36' => 'w-36',
        '40' => 'w-40',
        '44' => 'w-44',
        '48' => 'w-48',
        '56' => 'w-56',
        '64' => 'w-64',
        '72' => 'w-72',
        '80' => 'w-80',
    ];

    $alignClass = $alignmentClasses[$align] ?? $alignmentClasses['right'];
    $widthClass = $widthClasses[$width] ?? $widthClasses['48'];
@endphp

<div
    x-data="{ open: false }"
    @click.away="open = false"
    @close.stop="open = false"
    class="relative"
>
    <!-- Trigger -->
    <div @click="open = !open">
        {{ $trigger }}
    </div>

    <!-- Dropdown Content -->
    <div
        x-show="open"
        x-transition:enter="transition ease-out duration-200"
        x-transition:enter-start="opacity-0 scale-95"
        x-transition:enter-end="opacity-100 scale-100"
        x-transition:leave="transition ease-in duration-75"
        x-transition:leave-start="opacity-100 scale-100"
        x-transition:leave-end="opacity-0 scale-95"
        class="absolute z-50 mt-2 {{ $alignClass }} {{ $widthClass }} rounded-xl border border-white/10 shadow-xl shadow-black/30"
        style="display: none;"
        @click="open = false"
    >
        <div class="{{ $contentClasses }} rounded-xl overflow-hidden">
            {{ $content }}
        </div>
    </div>
</div>

