@props([
    'icon' => 'ph-folder-simple-dashed',
    'title' => null,
    'description' => null,
    'compact' => false
])

@php
    $title = $title ?? __('No data found');
@endphp

<div {{ $attributes->merge(['class' => 'flex flex-col items-center justify-center text-center ' . ($compact ? 'py-8 sm:py-12' : 'py-10 sm:py-16')]) }}>
    <div @class([
        'flex items-center justify-center rounded-xl sm:rounded-2xl bg-white/5 text-slate-500',
        'h-14 w-14 sm:h-20 sm:w-20 mb-3 sm:mb-5' => !$compact,
        'h-12 w-12 mb-2 sm:mb-3' => $compact,
    ])>
        <i @class([
            'ph-duotone',
            $icon,
            'text-2xl sm:text-4xl' => !$compact,
            'text-xl sm:text-2xl' => $compact,
        ])></i>
    </div>
    <h3 @class([
        'font-semibold text-white',
        'text-base sm:text-lg' => !$compact,
        'text-sm sm:text-base' => $compact,
    ])>{{ $title }}</h3>
    @if($description)
        <p @class([
            'mt-1.5 sm:mt-2 max-w-xs sm:max-w-sm text-slate-400 px-4',
            'text-xs sm:text-sm' => !$compact,
            'text-xs' => $compact,
        ])>{{ $description }}</p>
    @endif

    @if($slot->isNotEmpty())
        <div class="mt-4 sm:mt-6">
            {{ $slot }}
        </div>
    @endif
</div>

