@props([
    'label' => null,
    'name' => null,
    'id' => null,
    'accept' => 'image/*',
    'multiple' => false,
    'helper' => null,
    'error' => null,
    'preview' => null,
    'required' => false
])

@php
    $inputId = $id ?? $name ?? uniqid('file_');
    $hasError = $error || (isset($errors) && $name && $errors->has($name));
    $errorMessage = $error ?? ($name ? $errors->first($name) : null);
@endphp

<div {{ $attributes->only('class')->merge(['class' => 'space-y-2']) }}>
    @if($label)
        <label for="{{ $inputId }}" class="block text-sm font-medium text-slate-300 {{ $required ? 'after:ml-0.5 after:text-rose-400 after:content-[\'*\']' : '' }}">
            {{ $label }}
        </label>
    @endif

    <div
        x-data="{
            dragover: false,
            files: [],
            preview: @js($preview),
            handleFiles(fileList) {
                this.files = Array.from(fileList);
                if (this.files[0] && this.files[0].type.startsWith('image/')) {
                    const reader = new FileReader();
                    reader.onload = (e) => this.preview = e.target.result;
                    reader.readAsDataURL(this.files[0]);
                }
            }
        }"
        @dragover.prevent="dragover = true"
        @dragleave.prevent="dragover = false"
        @drop.prevent="dragover = false; handleFiles($event.dataTransfer.files)"
        :class="dragover && 'border-indigo-500/50 bg-indigo-500/5'"
        class="relative flex min-h-32 cursor-pointer flex-col items-center justify-center rounded-xl border-2 border-dashed border-white/10 p-6 transition-all hover:border-white/20 hover:bg-white/[0.02]"
    >
        <input
            type="file"
            id="{{ $inputId }}"
            @if($name) name="{{ $name }}" wire:model="{{ $name }}" @endif
            accept="{{ $accept }}"
            @if($multiple) multiple @endif
            @if($required) required @endif
            @change="handleFiles($event.target.files)"
            class="absolute inset-0 cursor-pointer opacity-0"
        >

        <template x-if="preview">
            <div class="relative">
                <img :src="preview" class="max-h-24 rounded-lg object-contain">
                <button
                    @click.prevent="preview = null; files = []; $refs.input.value = ''"
                    class="absolute -right-2 -top-2 flex h-6 w-6 items-center justify-center rounded-full bg-rose-500 text-white shadow-lg transition-transform hover:scale-110"
                >
                    <i class="ph-bold ph-x text-xs"></i>
                </button>
            </div>
        </template>

        <template x-if="!preview">
            <div class="text-center">
                <i class="ph-duotone ph-cloud-arrow-up text-4xl text-slate-500"></i>
                <p class="mt-2 text-sm font-medium text-slate-300">
                    Drop files here or <span class="text-indigo-400">browse</span>
                </p>
                <p class="mt-1 text-xs text-slate-500">
                    {{ $accept === 'image/*' ? 'PNG, JPG, GIF up to 10MB' : 'Max file size: 10MB' }}
                </p>
            </div>
        </template>
    </div>

    @if($helper && !$hasError)
        <p class="text-sm text-slate-500">{{ $helper }}</p>
    @endif

    @if($hasError)
        <p class="text-sm text-rose-400">{{ $errorMessage }}</p>
    @endif
</div>

