@props([
    'label' => 'Filter',
    'icon' => 'ph-funnel',
    'activeCount' => 0
])

<div
    x-data="{ open: false }"
    @click.away="open = false"
    class="relative"
>
    <button
        @click="open = !open"
        type="button"
        @class([
            'inline-flex items-center gap-2 rounded-xl border px-3 py-2 text-sm font-medium transition-colors',
            'border-slate-200 bg-white text-slate-700 hover:bg-slate-50 dark:border-slate-600 dark:bg-slate-700 dark:text-slate-300 dark:hover:bg-slate-600' => $activeCount === 0,
            'border-primary-200 bg-primary-50 text-primary-700 dark:border-primary-700 dark:bg-primary-900/30 dark:text-primary-400' => $activeCount > 0
        ])
    >
        <i class="ph-duotone {{ $icon }}"></i>
        <span>{{ $label }}</span>
        @if($activeCount > 0)
            <span class="flex h-5 min-w-5 items-center justify-center rounded-full bg-primary-600 px-1.5 text-xs font-semibold text-white">
                {{ $activeCount }}
            </span>
        @endif
        <i class="ph-bold ph-caret-down text-xs transition-transform" :class="open && 'rotate-180'"></i>
    </button>

    <div
        x-show="open"
        x-transition:enter="transition ease-out duration-100"
        x-transition:enter-start="transform opacity-0 scale-95"
        x-transition:enter-end="transform opacity-100 scale-100"
        x-transition:leave="transition ease-in duration-75"
        x-transition:leave-start="transform opacity-100 scale-100"
        x-transition:leave-end="transform opacity-0 scale-95"
        class="absolute right-0 top-full z-50 mt-2 min-w-64 overflow-hidden rounded-xl border border-slate-200 bg-white p-4 shadow-lg dark:border-slate-700 dark:bg-slate-800"
    >
        {{ $slot }}

        @if(isset($footer))
            <div class="mt-4 flex items-center justify-end gap-2 border-t border-slate-100 pt-4 dark:border-slate-700">
                {{ $footer }}
            </div>
        @endif
    </div>
</div>

