@props([
    'label' => null,
    'for' => null,
    'required' => false,
    'error' => null,
    'help' => null,
])

<div {{ $attributes->merge(['class' => 'space-y-1.5']) }}>
    @if($label)
        <label @if($for) for="{{ $for }}" @endif class="block text-sm font-medium text-slate-300">
            {{ $label }}
            @if($required)
                <span class="text-red-400">*</span>
            @endif
        </label>
    @endif

    {{ $slot }}

    @if($help && !$error)
        <p class="text-xs text-slate-500">{{ $help }}</p>
    @endif

    @if($error)
        <p class="text-xs text-red-400 flex items-center gap-1">
            <i class="ph-bold ph-warning-circle"></i>
            {{ $error }}
        </p>
    @endif
</div>

