@props(['title' => 'Dashboard'])

<!-- Admin Header -->
<header class="sticky top-0 z-30 flex h-14 lg:h-[72px] items-center gap-2 lg:gap-4 border-b border-white/5 bg-[#0a0a0f]/90 px-3 lg:px-8 backdrop-blur-2xl">
    <!-- Mobile Menu Button - Hamburger with animation -->
    <button
        @click="toggleMobileSidebar()"
        class="flex h-11 w-11 items-center justify-center rounded-xl text-slate-400 transition-all hover:bg-white/5 hover:text-white active:scale-95 lg:hidden"
        x-data="{ open: false }"
        :class="sidebarMobileOpen && 'bg-white/5 text-white'"
    >
        <div class="relative w-5 h-4 flex flex-col justify-between">
            <span
                class="block h-0.5 w-full bg-current transition-all duration-300 origin-center"
                :class="sidebarMobileOpen ? 'rotate-45 translate-y-[7px]' : ''"
            ></span>
            <span
                class="block h-0.5 w-full bg-current transition-all duration-300"
                :class="sidebarMobileOpen ? 'opacity-0 scale-0' : ''"
            ></span>
            <span
                class="block h-0.5 w-full bg-current transition-all duration-300 origin-center"
                :class="sidebarMobileOpen ? '-rotate-45 -translate-y-[7px]' : ''"
            ></span>
        </div>
    </button>

    <!-- Page Title / Search -->
    <div class="flex flex-1 items-center gap-4 min-w-0">
        <!-- Global Search - Desktop -->
        <div class="relative hidden max-w-lg flex-1 lg:block">
            <div class="pointer-events-none absolute inset-y-0 left-0 flex items-center pl-4">
                <i class="ph-duotone ph-magnifying-glass text-lg text-slate-500"></i>
            </div>
            <input
                type="search"
                placeholder="@lang('Search clients, orders, tickets...')"
                class="w-full rounded-2xl border border-white/5 bg-white/[0.03] py-3 pl-12 pr-20 text-sm text-slate-200 placeholder-slate-500 transition-all focus:border-indigo-500/30 focus:bg-white/5 focus:outline-none focus:ring-2 focus:ring-indigo-500/20"
            >
            <kbd class="pointer-events-none absolute right-4 top-1/2 -translate-y-1/2 rounded-lg border border-white/10 bg-white/5 px-2.5 py-1 text-[11px] font-medium text-slate-500">⌘K</kbd>
        </div>

        @if(config('app.demo_mode'))
            <div class="flex items-center gap-2 rounded-full border border-amber-500/20 bg-amber-500/10 px-3 py-1 text-[11px] font-bold uppercase tracking-wider text-amber-500 shadow-lg shadow-amber-500/10">
                <span class="relative flex h-2 w-2">
                    <span class="absolute inline-flex h-full w-full animate-ping rounded-full bg-amber-400 opacity-75"></span>
                    <span class="relative inline-flex h-2 w-2 rounded-full bg-amber-500"></span>
                </span>
                @lang('Demo Mode')
            </div>
        @endif
    </div>

    <!-- Right Section -->
    <div class="flex items-center gap-0.5 lg:gap-1">
        <!-- Quick Actions -->
        <div x-data="{ open: false, isMobile: window.innerWidth < 640 }" x-init="window.addEventListener('resize', () => isMobile = window.innerWidth < 640)" class="relative">
            <button
                @click="open = !open"
                class="flex h-10 w-10 lg:h-10 lg:w-10 items-center justify-center rounded-xl text-slate-400 transition-all hover:bg-white/5 hover:text-white active:scale-95"
            >
                <i class="ph-duotone ph-plus-circle text-xl"></i>
            </button>

            <!-- Quick Actions Dropdown - Bottom sheet on mobile -->
            <template x-if="isMobile">
                <div
                    x-show="open"
                    x-transition:enter="transition ease-out duration-300"
                    x-transition:enter-start="opacity-0"
                    x-transition:enter-end="opacity-100"
                    x-transition:leave="transition ease-in duration-200"
                    x-transition:leave-start="opacity-100"
                    x-transition:leave-end="opacity-0"
                    @click="open = false"
                    class="fixed inset-0 z-50 bg-black/70 backdrop-blur-sm"
                >
                    <div
                        @click.stop
                        x-show="open"
                        x-transition:enter="transition ease-out duration-300"
                        x-transition:enter-start="translate-y-full"
                        x-transition:enter-end="translate-y-0"
                        x-transition:leave="transition ease-in duration-200"
                        x-transition:leave-start="translate-y-0"
                        x-transition:leave-end="translate-y-full"
                        class="absolute bottom-0 left-0 right-0 rounded-t-2xl border-t border-white/10 bg-[#1a1a24] p-4 pb-safe"
                    >
                        <!-- Swipe indicator -->
                        <div class="flex justify-center mb-4">
                            <div class="h-1 w-10 rounded-full bg-white/20"></div>
                        </div>
                        <div class="mb-3 px-1">
                            <p class="text-xs font-bold uppercase tracking-wider text-slate-500">@lang('Quick Actions')</p>
                        </div>
                        <div class="space-y-1">
                            <a href="{{ route('admin.users.create') }}" wire:navigate class="flex items-center gap-3 rounded-xl px-3 py-3.5 text-sm text-slate-300 transition-all hover:bg-white/5 hover:text-white active:scale-[0.98]">
                                <div class="flex h-10 w-10 items-center justify-center rounded-xl bg-indigo-500/10">
                                    <i class="ph-duotone ph-user-plus text-xl text-indigo-400"></i>
                                </div>
                                @lang('New Client')
                            </a>
                            <a href="#" wire:navigate class="flex items-center gap-3 rounded-xl px-3 py-3.5 text-sm text-slate-300 transition-all hover:bg-white/5 hover:text-white active:scale-[0.98]">
                                <div class="flex h-10 w-10 items-center justify-center rounded-xl bg-emerald-500/10">
                                    <i class="ph-duotone ph-file-plus text-xl text-emerald-400"></i>
                                </div>
                                @lang('Create Invoice')
                            </a>
                            <a href="{{ route('admin.products.create') }}" wire:navigate class="flex items-center gap-3 rounded-xl px-3 py-3.5 text-sm text-slate-300 transition-all hover:bg-white/5 hover:text-white active:scale-[0.98]">
                                <div class="flex h-10 w-10 items-center justify-center rounded-xl bg-sky-500/10">
                                    <i class="ph-duotone ph-cube text-xl text-sky-400"></i>
                                </div>
                                @lang('Add Product')
                            </a>
                            <a href="{{ route('admin.ticket.index') }}" wire:navigate class="flex items-center gap-3 rounded-xl px-3 py-3.5 text-sm text-slate-300 transition-all hover:bg-white/5 hover:text-white active:scale-[0.98]">
                                <div class="flex h-10 w-10 items-center justify-center rounded-xl bg-amber-500/10">
                                    <i class="ph-duotone ph-chat-circle-dots text-xl text-amber-400"></i>
                                </div>
                                @lang('Open Ticket')
                            </a>
                        </div>
                        <button @click="open = false" class="mt-4 w-full rounded-xl bg-white/5 py-3.5 text-sm font-medium text-slate-400 hover:bg-white/10 active:scale-[0.98] transition-all">
                            @lang('Cancel')
                        </button>
                    </div>
                </div>
            </template>

            <!-- Quick Actions Dropdown - Desktop -->
            <template x-if="!isMobile">
                <div
                    x-show="open"
                    x-transition:enter="transition ease-out duration-150"
                    x-transition:enter-start="opacity-0 translate-y-2"
                    x-transition:enter-end="opacity-100 translate-y-0"
                    x-transition:leave="transition ease-in duration-100"
                    x-transition:leave-start="opacity-100 translate-y-0"
                    x-transition:leave-end="opacity-0 translate-y-2"
                    @click.away="open = false"
                    class="absolute right-0 top-full mt-3 w-64 overflow-hidden rounded-2xl border border-white/10 bg-[#1a1a24] p-2 shadow-2xl shadow-black/40"
                >
                    <div class="mb-2 px-3 py-2">
                        <p class="text-[11px] font-bold uppercase tracking-wider text-slate-500">@lang('Quick Actions')</p>
                    </div>
                    <a href="{{ route('admin.users.create') }}" wire:navigate class="flex items-center gap-3 rounded-xl px-3 py-2.5 text-sm text-slate-300 transition-all hover:bg-white/5 hover:text-white">
                        <div class="flex h-8 w-8 items-center justify-center rounded-lg bg-indigo-500/10">
                            <i class="ph-duotone ph-user-plus text-lg text-indigo-400"></i>
                        </div>
                        @lang('New Client')
                    </a>
                    <a href="#" wire:navigate class="flex items-center gap-3 rounded-xl px-3 py-2.5 text-sm text-slate-300 transition-all hover:bg-white/5 hover:text-white">
                        <div class="flex h-8 w-8 items-center justify-center rounded-lg bg-emerald-500/10">
                            <i class="ph-duotone ph-file-plus text-lg text-emerald-400"></i>
                        </div>
                        @lang('Create Invoice')
                    </a>
                    <a href="{{ route('admin.products.create') }}" wire:navigate class="flex items-center gap-3 rounded-xl px-3 py-2.5 text-sm text-slate-300 transition-all hover:bg-white/5 hover:text-white">
                        <div class="flex h-8 w-8 items-center justify-center rounded-lg bg-sky-500/10">
                            <i class="ph-duotone ph-cube text-lg text-sky-400"></i>
                        </div>
                        @lang('Add Product')
                    </a>
                    <a href="{{ route('admin.ticket.index') }}" wire:navigate class="flex items-center gap-3 rounded-xl px-3 py-2.5 text-sm text-slate-300 transition-all hover:bg-white/5 hover:text-white">
                        <div class="flex h-8 w-8 items-center justify-center rounded-lg bg-amber-500/10">
                            <i class="ph-duotone ph-chat-circle-dots text-lg text-amber-400"></i>
                        </div>
                        @lang('Open Ticket')
                    </a>
                </div>
            </template>
        </div>

        <!-- Notifications -->
        <livewire:admin.notification-dropdown />

        <!-- Mobile Search Button -->
        <div x-data="{ searchOpen: false }" class="lg:hidden">
            <button
                @click="searchOpen = true"
                class="flex h-10 w-10 items-center justify-center rounded-xl text-slate-400 transition-all hover:bg-white/5 hover:text-white active:scale-95"
            >
                <i class="ph-duotone ph-magnifying-glass text-xl"></i>
            </button>

            <!-- Mobile Search Overlay -->
            <div
                x-show="searchOpen"
                x-transition:enter="transition ease-out duration-200"
                x-transition:enter-start="opacity-0"
                x-transition:enter-end="opacity-100"
                x-transition:leave="transition ease-in duration-150"
                x-transition:leave-start="opacity-100"
                x-transition:leave-end="opacity-0"
                @keydown.escape.window="searchOpen = false"
                class="fixed inset-0 z-50 bg-[#0a0a0f]/95 backdrop-blur-xl"
            >
                <div class="flex flex-col h-full p-4 pt-safe">
                    <!-- Search Header -->
                    <div class="flex items-center gap-3 mb-4">
                        <div class="relative flex-1">
                            <div class="pointer-events-none absolute inset-y-0 left-0 flex items-center pl-4">
                                <i class="ph-duotone ph-magnifying-glass text-lg text-slate-500"></i>
                            </div>
                            <input
                                type="search"
                                x-ref="mobileSearch"
                                x-init="$watch('searchOpen', value => { if(value) $nextTick(() => $refs.mobileSearch.focus()) })"
                                placeholder="@lang('Search clients, orders, tickets...')"
                                class="w-full rounded-xl border border-white/10 bg-white/5 py-3.5 pl-12 pr-4 text-base text-slate-200 placeholder-slate-500 transition-all focus:border-indigo-500/30 focus:bg-white/10 focus:outline-none focus:ring-2 focus:ring-indigo-500/20"
                            >
                        </div>
                        <button
                            @click="searchOpen = false"
                            class="flex h-11 w-11 shrink-0 items-center justify-center rounded-xl text-slate-400 hover:bg-white/5 hover:text-white active:scale-95"
                        >
                            <i class="ph-bold ph-x text-xl"></i>
                        </button>
                    </div>

                    <!-- Quick Search Suggestions -->
                    <div class="flex-1 overflow-y-auto">
                        <p class="text-xs font-bold uppercase tracking-wider text-slate-500 mb-3">@lang('Quick Links')</p>
                        <div class="space-y-1">
                            <a href="{{ route('admin.users.all') }}" wire:navigate @click="searchOpen = false" class="flex items-center gap-3 rounded-xl px-3 py-3 text-sm text-slate-300 hover:bg-white/5 active:scale-[0.98]">
                                <i class="ph-duotone ph-users text-lg text-indigo-400"></i>
                                @lang('All Clients')
                            </a>
                            <a href="{{ route('admin.invoices.index') }}" wire:navigate @click="searchOpen = false" class="flex items-center gap-3 rounded-xl px-3 py-3 text-sm text-slate-300 hover:bg-white/5 active:scale-[0.98]">
                                <i class="ph-duotone ph-file-text text-lg text-emerald-400"></i>
                                @lang('All Invoices')
                            </a>
                            <a href="{{ route('admin.ticket.index') }}" wire:navigate @click="searchOpen = false" class="flex items-center gap-3 rounded-xl px-3 py-3 text-sm text-slate-300 hover:bg-white/5 active:scale-[0.98]">
                                <i class="ph-duotone ph-headset text-lg text-amber-400"></i>
                                @lang('All Tickets')
                            </a>
                            <a href="{{ route('admin.orders.index') }}" wire:navigate @click="searchOpen = false" class="flex items-center gap-3 rounded-xl px-3 py-3 text-sm text-slate-300 hover:bg-white/5 active:scale-[0.98]">
                                <i class="ph-duotone ph-shopping-cart text-lg text-sky-400"></i>
                                @lang('All Orders')
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</header>

