@props([
    'label' => null,
    'name' => null,
    'id' => null,
    'required' => false,
    'placeholder' => __('Search icons...'),
])

@php
    $inputId = $id ?? $name ?? uniqid('icon_picker_');
    $hasWireModel = $attributes->whereStartsWith('wire:model')->isNotEmpty();
    
    // Curated list of Phosphor Icons (Duotone)
    $availableIcons = [
        'cube', 'folder', 'folder-open', 'cloud', 'database', 'shield', 'shield-check', 'globe', 'cpu', 'hard-drive',
        'monitor', 'terminal', 'code', 'layout', 'shopping-cart', 'tag', 'package', 'users', 'users-three', 'user',
        'gear', 'settings-cross', 'lifebuoy', 'lightning', 'rocket', 'rocket-launch', 'star', 'heart', 'bell', 'chat',
        'chat-centered', 'article', 'list', 'briefcase', 'wallet', 'credit-card', 'bank', 'money', 'chart-bar', 'chart-line',
        'chart-pie', 'activity', 'airplane', 'alarm', 'app-window', 'archive', 'at', 'atom', 'badge', 'bar-code',
        'battery-charging', 'beaker', 'blueprint', 'book', 'bookmark', 'broadcast', 'browser', 'bug', 'buildings', 'calendar',
        'camera', 'car', 'cardholder', 'cards', 'certificate', 'check', 'check-circle', 'circle', 'clipboard', 'clock',
        'coffee', 'compass', 'copy', 'crown', 'desktop', 'devices', 'diamond', 'dots-three', 'download', 'ear',
        'engine', 'envelope', 'eye', 'file', 'file-cloud', 'file-code', 'file-css', 'file-html', 'file-js', 'file-pdf',
        'file-text', 'fingerprint', 'fire', 'flag', 'flask', 'floppy-disk', 'funnel', 'game-controller', 'gauge', 'gift',
        'graduation-cap', 'graph', 'hammer', 'hand-pointing', 'hash', 'headset', 'house', 'image', 'infinity', 'info',
        'key', 'keyboard', 'laptop', 'leaf', 'link', 'list-checks', 'lock', 'magic-wand', 'map-pin', 'medal',
        'megaphone', 'microphone', 'minus', 'moon', 'mouse', 'music-notes', 'navigation-arrow', 'newspaper', 'notebook', 'nut',
        'open-metis', 'paint-brush', 'paper-plane-tilt', 'pencil', 'phone', 'phosphor-logo', 'piano-keys', 'picture-in-picture', 'play',
        'playlist', 'plug', 'plus', 'poker-chip', 'power', 'presentation', 'printer', 'prohibit', 'puzzle-piece', 'qr-code',
        'question', 'quotes', 'radio', 'receipt', 'record', 'recycle', 'refresh', 'repeat', 'rss', 'scales',
        'scissors', 'screencast', 'screwdriver', 'selection', 'share-network', 'shirt-folded', 'shooting-star', 'shuffle', 'sidebar', 'sign-in',
        'sketch-logo', 'slack-logo', 'sliders', 'smiley', 'speaker-high', 'stack', 'sticker', 'stop', 'suitcase', 'sun',
        'swords', 'table', 'target', 'television', 'test-tube', 'text-t', 'thermometer', 'thumbs-up', 'ticket', 'timer',
        'toolbox', 'tote', 'traffic-cone', 'train', 'trash', 'tree', 'trend-up', 'trophy', 'truck', 'umbrella',
        'upload', 'vibrate', 'video-camera', 'vignette', 'voicemail', 'warning', 'watch', 'waves', 'webcam', 'wifi-high',
        'wrench', 'youtube-logo',
    ];

    // Remove duplicates and sort for cleaner UI
    $availableIcons = array_values(array_unique($availableIcons));
    sort($availableIcons);
@endphp

<div
    x-data="{
        show: false,
        search: '',
        selected: @entangle($attributes->wire('model')),
        icons: {{ json_encode($availableIcons) }},
        get filteredIcons() {
            if (!this.search) return this.icons;
            return this.icons.filter(i => i.toLowerCase().includes(this.search.toLowerCase()));
        },
        select(icon) {
            this.selected = 'ph-' + icon;
            this.show = false;
        }
    }"
    class="space-y-1.5 sm:space-y-2"
    @click.away="show = false"
>
    @if($label)
        <label class="block text-xs sm:text-sm font-medium text-slate-300 {{ $required ? 'after:ml-0.5 after:text-rose-400 after:content-[\'*\']' : '' }}">
            {{ $label }}
        </label>
    @endif

    <div class="relative">
        {{-- Selected Icon Trigger --}}
        <button
            type="button"
            @click="show = !show"
            class="flex w-full items-center gap-3 rounded-lg sm:rounded-xl border border-white/10 bg-white/5 px-3 sm:px-4 py-3 sm:py-3.5 text-left transition-all hover:bg-white/10 focus:border-indigo-500/50 focus:outline-none focus:ring-2 focus:ring-indigo-500/20"
        >
            <div class="flex h-10 w-10 shrink-0 items-center justify-center rounded-lg bg-indigo-500/10 text-indigo-400 border border-indigo-500/20">
                <i class="ph-duotone text-xl" :class="selected || 'ph-folder'"></i>
            </div>
            <div class="flex-grow">
                <span class="block text-sm font-medium text-white" x-text="selected ? selected : '{{ __('Select an icon') }}'"></span>
                <span class="block text-xs text-slate-500">Phosphor Duotone Library</span>
            </div>
            <i class="ph-bold ph-caret-down text-slate-500 transition-transform" :class="show ? 'rotate-180' : ''"></i>
        </button>

        {{-- Icon Dropdown Picker --}}
        <div
            wire:ignore
            x-show="show"
            x-transition:enter="transition ease-out duration-200"
            x-transition:enter-start="opacity-0 scale-95 translate-y-2"
            x-transition:enter-end="opacity-100 scale-100 translate-y-0"
            x-transition:leave="transition ease-in duration-100"
            x-transition:leave-start="opacity-100 scale-100 translate-y-0"
            x-transition:leave-end="opacity-0 scale-95 translate-y-2"
            class="absolute z-50 mt-2 w-full max-w-[400px] overflow-hidden rounded-2xl border border-white/10 bg-[#16161e] shadow-2xl backdrop-blur-xl"
            style="display: none;"
        >
            {{-- Search Bar --}}
            <div class="border-b border-white/5 p-4">
                <div class="relative">
                    <i class="ph-duotone ph-magnifying-glass absolute left-3 top-1/2 -translate-y-1/2 text-slate-500"></i>
                    <input
                        type="text"
                        x-model="search"
                        placeholder="{{ $placeholder }}"
                        class="w-full rounded-xl border border-white/10 bg-white/5 py-2 pl-10 pr-4 text-sm text-white placeholder-slate-500 transition-all focus:border-indigo-500/50 focus:outline-none"
                        @click.stop
                    >
                </div>
            </div>

            {{-- Icon Grid --}}
            <div class="max-h-[320px] overflow-y-auto p-4 custom-scrollbar">
                <div class="grid grid-cols-4 sm:grid-cols-6 gap-2">
                    <template x-for="icon in filteredIcons" :key="icon">
                        <button
                            type="button"
                            @click="select(icon)"
                            class="group flex flex-col items-center justify-center gap-1.5 rounded-xl p-2 transition-all hover:bg-indigo-500/20 border border-transparent hover:border-indigo-500/30"
                            :class="selected === 'ph-' + icon ? 'bg-indigo-500/20 border-indigo-500/50' : ''"
                            :title="icon"
                        >
                            <i class="ph-duotone text-2xl text-slate-400 group-hover:text-indigo-400" :class="'ph-' + icon, selected === 'ph-' + icon ? 'text-indigo-400' : ''"></i>
                            <span class="hidden text-[10px] text-slate-500 group-hover:text-slate-300 truncate w-full text-center" x-text="icon"></span>
                        </button>
                    </template>
                </div>

                {{-- Empty State --}}
                <div x-show="filteredIcons.length === 0" class="py-8 text-center" style="display: none;">
                    <i class="ph-duotone ph-magnifying-glass text-3xl text-slate-600"></i>
                    <p class="mt-2 text-sm text-slate-500">No icons match your search</p>
                </div>
            </div>
        </div>
    </div>
</div>
