@props([
    'label' => '',
    'value' => null,
    'icon' => null,
    'copyable' => false,
    'compact' => false
])

<div {{ $attributes->merge(['class' => 'flex flex-col gap-0.5 sm:gap-1 py-2.5 sm:py-3 px-3 sm:px-0 sm:flex-row sm:items-center sm:gap-4']) }}>
    <dt @class([
        'flex items-center gap-1.5 sm:gap-2 font-medium text-slate-500 sm:w-1/3',
        'text-xs sm:text-sm' => !$compact,
        'text-xs' => $compact,
    ])>
        @if($icon)
            <i class="ph-duotone {{ $icon }} text-base sm:text-lg shrink-0"></i>
        @endif
        <span class="truncate">{{ $label }}</span>
    </dt>
    <dd @class([
        'flex items-center gap-2 text-white sm:w-2/3 min-w-0',
        'text-xs sm:text-sm' => !$compact,
        'text-xs' => $compact,
    ])>
        @if($slot->isNotEmpty())
            <span class="min-w-0 truncate">{{ $slot }}</span>
        @else
            <span class="min-w-0 truncate">{{ $value ?? '—' }}</span>
        @endif

        @if($copyable && $value)
            <button
                type="button"
                x-data="{ copied: false }"
                @click="navigator.clipboard.writeText('{{ $value }}'); copied = true; setTimeout(() => copied = false, 2000)"
                class="shrink-0 text-slate-500 transition-colors hover:text-white min-h-8 min-w-8 sm:min-h-0 sm:min-w-0 flex items-center justify-center rounded-lg hover:bg-white/5"
            >
                <i class="ph-duotone text-sm" :class="copied ? 'ph-check text-emerald-400' : 'ph-copy'"></i>
            </button>
        @endif
    </dd>
</div>

