@props([
    'type' => 'text',
    'label' => null,
    'name' => null,
    'id' => null,
    'placeholder' => null,
    'helper' => null,
    'error' => null,
    'required' => false,
    'disabled' => false,
    'icon' => null,
    'prefix' => null,
    'suffix' => null,
    'clearable' => false,
])

@php
    $inputId = $id ?? $name ?? uniqid('input_');
    $hasWireModel = $attributes->whereStartsWith('wire:model')->isNotEmpty();
    
    // Auto-detect name from wire:model if missing
    if (!$name && $hasWireModel) {
        $name = $attributes->whereStartsWith('wire:model')->first();
    }

    $hasError = $error || (isset($errors) && $errors instanceof \Illuminate\Support\MessageBag && $name && $errors->has($name));
    $errorMessage = $error ?? (isset($errors) && $errors instanceof \Illuminate\Support\MessageBag && $name ? $errors->first($name) : null);

    // Keyboard type hints for mobile
    $inputMode = match($type) {
        'email' => 'email',
        'tel' => 'tel',
        'url' => 'url',
        'number' => 'decimal',
        default => null,
    };
@endphp

<div
    {{ $attributes->only('class')->merge(['class' => 'space-y-1.5 sm:space-y-2']) }}
    @if($clearable) x-data="{ value: '' }" @endif
>
    @if($label)
        <label for="{{ $inputId }}" class="block text-xs sm:text-sm font-medium text-slate-300 {{ $required ? 'after:ml-0.5 after:text-rose-400 after:content-[\'*\']' : '' }}">
            {{ $label }}
        </label>
    @endif

    <div class="relative">
        @if($icon)
            <span class="pointer-events-none absolute inset-y-0 left-0 flex items-center pl-3 sm:pl-4 text-slate-500">
                <i class="ph-duotone ph-{{ $icon }} text-base sm:text-lg"></i>
            </span>
        @endif

        @if($prefix)
            <span class="pointer-events-none absolute inset-y-0 left-0 flex items-center pl-3 sm:pl-4 text-xs sm:text-sm text-slate-500">
                {{ $prefix }}
            </span>
        @endif

        <input
            type="{{ $type }}"
            id="{{ $inputId }}"
            @if($name) name="{{ $name }}" @endif
            @if($name && !$hasWireModel) wire:model="{{ $name }}" @endif
            @if($placeholder) placeholder="{{ $placeholder }}" @endif
            @if($inputMode) inputmode="{{ $inputMode }}" @endif
            @if($clearable) x-model="value" @endif
            class="block w-full rounded-lg sm:rounded-xl border border-white/10 bg-white/5 px-3 sm:px-4 py-3 sm:py-3.5 text-base sm:text-sm text-white placeholder-slate-500 transition-all focus:border-indigo-500/50 focus:bg-white/10 focus:outline-none focus:ring-2 focus:ring-indigo-500/20 disabled:cursor-not-allowed disabled:opacity-50 {{ $hasError ? 'border-rose-500/50 focus:border-rose-500/50 focus:ring-rose-500/20' : '' }} {{ $icon ? 'pl-10 sm:pl-11' : '' }} {{ $prefix ? 'pl-9 sm:pl-10' : '' }} {{ $suffix || $clearable ? 'pr-12 sm:pr-16' : '' }}"
            @if($required) required @endif
            @if($disabled) disabled @endif
            {{ $attributes->except('class') }}
        >

        {{-- Clear button for mobile --}}
        @if($clearable)
            <button
                type="button"
                x-show="value.length > 0"
                x-transition
                @click="value = ''; $refs.input?.focus()"
                class="absolute inset-y-0 right-0 flex items-center pr-3 sm:pr-4 text-slate-500 hover:text-white active:scale-90 transition-all"
            >
                <i class="ph-bold ph-x-circle text-lg"></i>
            </button>
        @endif

        @if($suffix)
            <span class="pointer-events-none absolute inset-y-0 right-0 flex items-center pr-3 sm:pr-4 text-xs sm:text-sm text-slate-500">
                {{ $suffix }}
            </span>
        @endif
    </div>

    @if($helper && !$hasError)
        <p class="text-xs sm:text-sm text-slate-500">{{ $helper }}</p>
    @endif

    @if($hasError)
        <p class="flex items-center gap-1.5 text-xs sm:text-sm text-rose-400">
            <i class="ph-bold ph-warning-circle shrink-0"></i>
            {{ $errorMessage }}
        </p>
    @endif
</div>

