@props([
    'name' => 'modal',
    'title' => null,
    'maxWidth' => 'lg',
    'closeable' => true,
    'icon' => null,
    'fullscreenMobile' => true,
])

@php
    $maxWidthClasses = [
        'sm' => 'sm:max-w-sm',
        'md' => 'sm:max-w-md',
        'lg' => 'sm:max-w-lg',
        'xl' => 'sm:max-w-xl',
        '2xl' => 'sm:max-w-2xl',
        '3xl' => 'sm:max-w-3xl',
        '4xl' => 'sm:max-w-4xl',
        '5xl' => 'sm:max-w-5xl',
        'full' => 'sm:max-w-full sm:mx-4',
    ];

    $maxWidthClass = $maxWidthClasses[$maxWidth] ?? $maxWidthClasses['lg'];

    // Mobile fullscreen classes
    $mobileClass = $fullscreenMobile
        ? 'fixed inset-0 sm:relative sm:inset-auto max-h-screen sm:max-h-[90vh] rounded-none sm:rounded-2xl'
        : 'rounded-2xl max-h-[90vh]';

    // Check if wire:model is being used (check both wire:model and wire:model.live)
    $hasWireModel = $attributes->has('wire:model') || $attributes->has('wire:model.live');
@endphp

@if($hasWireModel)
{{-- wire:model based modal --}}
<div
    x-data="{
        show: @entangle($attributes->wire('model')),
        startY: 0,
        currentY: 0,
        dragging: false
    }"
    x-on:close.stop="show = false"
    x-on:keydown.escape.window="@if($closeable) show = false @endif"
    x-init="$watch('show', value => { document.body.style.overflow = value ? 'hidden' : '' })"
    x-show="show"
    x-cloak
    class="fixed inset-0 z-50 overflow-hidden"
    {{ $attributes->except(['wire:model', 'wire:model.live']) }}
>
    <!-- Backdrop -->
    <div
        x-show="show"
        x-transition:enter="ease-out duration-300"
        x-transition:enter-start="opacity-0"
        x-transition:enter-end="opacity-100"
        x-transition:leave="ease-in duration-200"
        x-transition:leave-start="opacity-100"
        x-transition:leave-end="opacity-0"
        @if($closeable) @click="show = false" @endif
        class="fixed inset-0 bg-black/70 backdrop-blur-sm"
    ></div>

    <!-- Modal Container - Full screen on mobile, centered on desktop -->
    <div class="flex min-h-full items-end sm:items-center justify-center sm:p-4">
        <div
            x-show="show"
            x-transition:enter="ease-out duration-300"
            x-transition:enter-start="opacity-0 translate-y-full sm:translate-y-4 sm:scale-95"
            x-transition:enter-end="opacity-100 translate-y-0 sm:scale-100"
            x-transition:leave="ease-in duration-200"
            x-transition:leave-start="opacity-100 translate-y-0 sm:scale-100"
            x-transition:leave-end="opacity-0 translate-y-full sm:translate-y-4 sm:scale-95"
            @if($closeable && $fullscreenMobile)
                @touchstart.passive="startY = $event.touches[0].clientY; dragging = true"
                @touchmove.passive="if(dragging) currentY = $event.touches[0].clientY - startY"
                @touchend="if(currentY > 100) show = false; currentY = 0; dragging = false"
            @endif
            :style="dragging && currentY > 0 ? 'transform: translateY(' + currentY + 'px)' : ''"
            class="relative w-full flex flex-col border-white/10 bg-[#12121a] shadow-2xl shadow-black/50 transition-all {{ $mobileClass }} {{ $maxWidthClass }} sm:border"
        >
            {{-- Mobile swipe indicator --}}
            @if($closeable && $fullscreenMobile)
                <div class="flex justify-center pt-3 pb-1 sm:hidden">
                    <div class="h-1 w-10 rounded-full bg-white/20"></div>
                </div>
            @endif

            {{-- Header --}}
            <div class="flex items-center justify-between border-b border-white/5 px-4 sm:px-6 py-3 sm:py-4 shrink-0">
                <div class="flex items-center gap-3 min-w-0 flex-1 pr-4">
                    @if($icon)
                        <div class="flex h-10 w-10 shrink-0 items-center justify-center rounded-xl bg-white/5">
                            <i class="ph-duotone {{ $icon }} text-xl text-indigo-400"></i>
                        </div>
                    @endif
                    @if($title)
                        <h3 class="text-base sm:text-lg font-semibold text-white truncate">{{ $title }}</h3>
                    @endif
                </div>
                @if($closeable)
                    <button
                        type="button"
                        @click="show = false"
                        class="flex h-10 w-10 shrink-0 cursor-pointer items-center justify-center rounded-xl text-slate-500 transition-all hover:bg-white/5 hover:text-white active:scale-95"
                    >
                        <i class="ph-bold ph-x text-lg"></i>
                    </button>
                @endif
            </div>

            {{-- Content --}}
            <div class="flex-1 overflow-y-auto overscroll-contain p-4 sm:p-6">
                {{ $slot }}
            </div>

            {{-- Footer --}}
            @if(isset($footer))
                <div class="flex flex-col-reverse sm:flex-row items-stretch sm:items-center justify-end gap-2 sm:gap-3 border-t border-white/5 px-4 sm:px-6 py-4 shrink-0 pb-safe">
                    {{ $footer }}
                </div>
            @endif
        </div>
    </div>
</div>
@else
{{-- Event-based modal --}}
<div
    x-data="{
        show: false,
        startY: 0,
        currentY: 0,
        dragging: false
    }"
    x-on:open-modal.window="($event.detail === '{{ $name }}' || $event.detail?.name === '{{ $name }}') && (show = true)"
    x-on:close-modal.window="($event.detail === '{{ $name }}' || $event.detail?.name === '{{ $name }}') && (show = false)"
    x-on:close.stop="show = false"
    x-on:keydown.escape.window="@if($closeable) show = false @endif"
    x-init="$watch('show', value => { document.body.style.overflow = value ? 'hidden' : '' })"
    x-show="show"
    x-cloak
    class="fixed inset-0 z-50 overflow-hidden"
    {{ $attributes }}
>
    <!-- Backdrop -->
    <div
        x-show="show"
        x-transition:enter="ease-out duration-300"
        x-transition:enter-start="opacity-0"
        x-transition:enter-end="opacity-100"
        x-transition:leave="ease-in duration-200"
        x-transition:leave-start="opacity-100"
        x-transition:leave-end="opacity-0"
        @if($closeable) @click="show = false" @endif
        class="fixed inset-0 bg-black/70 backdrop-blur-sm"
    ></div>

    <!-- Modal Container - Full screen on mobile, centered on desktop -->
    <div class="flex min-h-full items-end sm:items-center justify-center sm:p-4">
        <div
            x-show="show"
            x-transition:enter="ease-out duration-300"
            x-transition:enter-start="opacity-0 translate-y-full sm:translate-y-4 sm:scale-95"
            x-transition:enter-end="opacity-100 translate-y-0 sm:scale-100"
            x-transition:leave="ease-in duration-200"
            x-transition:leave-start="opacity-100 translate-y-0 sm:scale-100"
            x-transition:leave-end="opacity-0 translate-y-full sm:translate-y-4 sm:scale-95"
            @if($closeable && $fullscreenMobile)
                @touchstart.passive="startY = $event.touches[0].clientY; dragging = true"
                @touchmove.passive="if(dragging) currentY = $event.touches[0].clientY - startY"
                @touchend="if(currentY > 100) show = false; currentY = 0; dragging = false"
            @endif
            :style="dragging && currentY > 0 ? 'transform: translateY(' + currentY + 'px)' : ''"
            class="relative w-full flex flex-col border-white/10 bg-[#12121a] shadow-2xl shadow-black/50 transition-all {{ $mobileClass }} {{ $maxWidthClass }} sm:border"
        >
            {{-- Mobile swipe indicator --}}
            @if($closeable && $fullscreenMobile)
                <div class="flex justify-center pt-3 pb-1 sm:hidden">
                    <div class="h-1 w-10 rounded-full bg-white/20"></div>
                </div>
            @endif

            {{-- Header --}}
            <div class="flex items-center justify-between border-b border-white/5 px-4 sm:px-6 py-3 sm:py-4 shrink-0">
                <div class="flex items-center gap-3 min-w-0 flex-1 pr-4">
                    @if($icon)
                        <div class="flex h-10 w-10 shrink-0 items-center justify-center rounded-xl bg-white/5">
                            <i class="ph-duotone {{ $icon }} text-xl text-indigo-400"></i>
                        </div>
                    @endif
                    @if($title)
                        <h3 class="text-base sm:text-lg font-semibold text-white truncate">{{ $title }}</h3>
                    @endif
                </div>
                @if($closeable)
                    <button
                        type="button"
                        @click="show = false"
                        class="flex h-10 w-10 shrink-0 cursor-pointer items-center justify-center rounded-xl text-slate-500 transition-all hover:bg-white/5 hover:text-white active:scale-95"
                    >
                        <i class="ph-bold ph-x text-lg"></i>
                    </button>
                @endif
            </div>

            {{-- Content --}}
            <div class="flex-1 overflow-y-auto overscroll-contain p-4 sm:p-6">
                {{ $slot }}
            </div>

            {{-- Footer --}}
            @if(isset($footer))
                <div class="flex flex-col-reverse sm:flex-row items-stretch sm:items-center justify-end gap-2 sm:gap-3 border-t border-white/5 px-4 sm:px-6 py-4 shrink-0 pb-safe">
                    {{ $footer }}
                </div>
            @endif
        </div>
    </div>
</div>
@endif

