@props([
    'icon' => 'ph-folder',
    'label' => '',
    'expanded' => false
])

<div
    x-data="{ groupOpen: {{ $expanded ? 'true' : 'false' }} }"
>
    <!-- Group Header -->
    <button
        @click="sidebarOpen ? (groupOpen = !groupOpen) : null"
        class="group flex w-full items-center gap-3 rounded-xl px-3 py-2.5 text-left text-[13px] font-medium text-slate-400 transition-all cursor-pointer hover:bg-white/[0.03] hover:text-slate-200"
        :class="!sidebarOpen && 'justify-center px-2.5'"
    >
        <i class="ph-duotone {{ $icon }} shrink-0 text-lg transition-all group-hover:scale-110 group-hover:text-slate-300"></i>

        <span
            x-show="sidebarOpen"
            x-transition:enter="transition-opacity duration-200"
            x-transition:enter-start="opacity-0"
            x-transition:enter-end="opacity-100"
            class="flex-1 truncate"
        >
            {{ $label }}
        </span>

        <i
            x-show="sidebarOpen"
            class="ph-bold ph-caret-down text-[10px] text-slate-500 transition-transform duration-200"
            :class="groupOpen && 'rotate-180'"
        ></i>
    </button>

    <!-- Group Items -->
    <div
        x-show="sidebarOpen ? groupOpen : true"
        x-transition:enter="transition ease-out duration-200"
        x-transition:enter-start="opacity-0 -translate-y-1"
        x-transition:enter-end="opacity-100 translate-y-0"
        x-transition:leave="transition ease-in duration-150"
        x-transition:leave-start="opacity-100 translate-y-0"
        x-transition:leave-end="opacity-0 -translate-y-1"
        class="mt-1 space-y-0.5"
        :class="sidebarOpen && 'ml-5 border-l border-white/5 pl-3'"
    >
        {{ $slot }}
    </div>
</div>

