@props([
    'icon' => 'ph-circle',
    'label' => '',
    'route' => '#',
    'badge' => null,
    'badgeType' => 'primary'
])

@php
    $isActive = Route::has($route) ? request()->routeIs($route . '*') : false;
    $href = Route::has($route) ? route($route) : '#';

    $badgeColors = [
        'primary' => 'bg-indigo-500/20 text-indigo-300',
        'success' => 'bg-emerald-500/20 text-emerald-300',
        'warning' => 'bg-amber-500/20 text-amber-300',
        'danger' => 'bg-rose-500/20 text-rose-300',
        'info' => 'bg-sky-500/20 text-sky-300',
    ];

    $badgeColor = $badgeColors[$badgeType] ?? $badgeColors['primary'];
@endphp

<a
    href="{{ $href }}"
    wire:navigate
    @class([
        'group relative flex items-center gap-3 rounded-xl px-3 py-2.5 text-[13px] font-medium transition-all duration-200 cursor-pointer',
        'bg-gradient-to-r from-indigo-500/15 to-purple-500/10 text-white before:absolute before:inset-y-1.5 before:left-0 before:w-[3px] before:rounded-full before:bg-gradient-to-b before:from-indigo-400 before:to-purple-400' => $isActive,
        'text-slate-400 hover:bg-white/[0.03] hover:text-slate-200' => !$isActive,
    ])
    :class="!sidebarOpen && 'justify-center px-2.5'"
>
    <i @class([
        'ph-duotone text-lg shrink-0 transition-all group-hover:scale-110',
        $icon,
        'text-indigo-400' => $isActive,
        'group-hover:text-slate-300' => !$isActive,
    ])></i>

    <span
        x-show="sidebarOpen"
        x-transition:enter="transition-opacity duration-200"
        x-transition:enter-start="opacity-0"
        x-transition:enter-end="opacity-100"
        class="flex-1 truncate"
    >
        {{ $label }}
    </span>

    @if($badge)
        <span
            x-show="sidebarOpen"
            class="{{ $badgeColor }} min-w-5 rounded-lg px-2 py-0.5 text-center text-[11px] font-semibold"
        >
            {{ $badge }}
        </span>
    @endif
</a>

