@props([
    'icon' => 'ph-bell',
    'iconColor' => 'primary',
    'title' => '',
    'description' => '',
    'time' => '',
    'read' => false,
    'href' => '#'
])

@php
    $iconBgColors = [
        'primary' => 'bg-indigo-500/10 text-indigo-400',
        'success' => 'bg-emerald-500/10 text-emerald-400',
        'warning' => 'bg-amber-500/10 text-amber-400',
        'danger' => 'bg-rose-500/10 text-rose-400',
        'info' => 'bg-sky-500/10 text-sky-400',
    ];

    $iconBg = $iconBgColors[$iconColor] ?? $iconBgColors['primary'];
@endphp

<a
    href="{{ $href }}"
    @class([
        'flex items-start gap-4 px-5 py-4 transition-all hover:bg-white/[0.02]',
        'bg-indigo-500/5' => !$read,
    ])
>
    <div class="{{ $iconBg }} flex h-10 w-10 shrink-0 items-center justify-center rounded-xl">
        <i class="ph-duotone {{ $icon }} text-lg"></i>
    </div>
    <div class="min-w-0 flex-1">
        <p @class([
            'truncate text-sm',
            'font-semibold text-white' => !$read,
            'font-medium text-slate-300' => $read,
        ])>{{ $title }}</p>
        <p class="mt-0.5 truncate text-[13px] text-slate-400">{{ $description }}</p>
        <p class="mt-1.5 text-xs text-slate-500">{{ $time }}</p>
    </div>
    @unless($read)
        <span class="mt-1.5 h-2 w-2 shrink-0 rounded-full bg-indigo-500"></span>
    @endunless
</a>

