@props([
    'label' => null,
    'name' => null,
    'id' => null,
    'value' => null,
    'min' => null,
    'max' => null,
    'step' => 1,
    'placeholder' => '0',
    'helper' => null,
    'error' => null,
    'required' => false,
    'disabled' => false,
    'prefix' => null,
    'suffix' => null
])

@php
    $inputId = $id ?? $name ?? uniqid('number_');
    $hasError = $error || (isset($errors) && $name && $errors->has($name));
    $errorMessage = $error ?? ($name ? $errors->first($name) : null);
@endphp

<div {{ $attributes->only('class')->merge(['class' => 'space-y-1']) }}>
    @if($label)
        <label for="{{ $inputId }}" @class(['label', 'label-required' => $required])>
            {{ $label }}
        </label>
    @endif
    
    <div 
        x-data="{ value: {{ $value ?? 0 }} }"
        class="flex items-center"
    >
        @if($prefix)
            <span class="flex h-11 items-center rounded-l-xl border border-r-0 border-slate-200 bg-slate-50 px-3 text-sm text-slate-500">
                {{ $prefix }}
            </span>
        @endif
        
        <div class="relative flex-1">
            <button 
                type="button"
                @click="value = Math.max({{ $min ?? 'Number.MIN_SAFE_INTEGER' }}, value - {{ $step }})"
                @disabled($disabled)
                class="absolute inset-y-0 left-0 flex w-10 items-center justify-center text-slate-400 transition-colors hover:text-slate-600 disabled:cursor-not-allowed disabled:opacity-50"
            >
                <i class="ph-bold ph-minus"></i>
            </button>
            
            <input 
                type="number"
                id="{{ $inputId }}"
                @if($name) name="{{ $name }}" wire:model="{{ $name }}" @endif
                x-model="value"
                @if($min !== null) min="{{ $min }}" @endif
                @if($max !== null) max="{{ $max }}" @endif
                step="{{ $step }}"
                placeholder="{{ $placeholder }}"
                @required($required)
                @disabled($disabled)
                {{ $attributes->except('class') }}
                @class([
                    'w-full border border-slate-200 bg-white px-12 py-2.5 text-center text-sm text-slate-900 transition-all focus:border-primary-500 focus:outline-none focus:ring-2 focus:ring-primary-500/20',
                    'rounded-xl' => !$prefix && !$suffix,
                    'rounded-none' => $prefix && $suffix,
                    'rounded-r-xl' => $prefix && !$suffix,
                    'rounded-l-xl' => !$prefix && $suffix,
                    'border-danger-500 focus:border-danger-500 focus:ring-danger-500/20' => $hasError,
                    'cursor-not-allowed opacity-50' => $disabled
                ])
            >
            
            <button 
                type="button"
                @click="value = Math.min({{ $max ?? 'Number.MAX_SAFE_INTEGER' }}, value + {{ $step }})"
                @disabled($disabled)
                class="absolute inset-y-0 right-0 flex w-10 items-center justify-center text-slate-400 transition-colors hover:text-slate-600 disabled:cursor-not-allowed disabled:opacity-50"
            >
                <i class="ph-bold ph-plus"></i>
            </button>
        </div>
        
        @if($suffix)
            <span class="flex h-11 items-center rounded-r-xl border border-l-0 border-slate-200 bg-slate-50 px-3 text-sm text-slate-500">
                {{ $suffix }}
            </span>
        @endif
    </div>
    
    @if($helper && !$hasError)
        <p class="helper-text">{{ $helper }}</p>
    @endif
    
    @if($hasError)
        <p class="error-text">{{ $errorMessage }}</p>
    @endif
</div>

