@props([
    'title' => '',
    'subtitle' => null,
    'backRoute' => null,
    'backLabel' => null,
])

<div {{ $attributes->merge(['class' => 'flex flex-col gap-3 sm:gap-4']) }}>
    {{-- Back button for mobile navigation --}}
    @if($backRoute)
        <a href="{{ $backRoute }}" class="inline-flex items-center gap-2 text-sm text-slate-400 hover:text-white transition-colors -mt-1 sm:hidden">
            <i class="ph-bold ph-arrow-left text-base"></i>
            {{ $backLabel ?? __('Back') }}
        </a>
    @endif

    <div class="flex flex-col gap-3 sm:flex-row sm:items-center sm:justify-between">
        <div class="min-w-0 flex-1">
            {{-- Back button for desktop --}}
            @if($backRoute)
                <a href="{{ $backRoute }}" class="hidden sm:inline-flex items-center gap-2 text-sm text-slate-400 hover:text-white transition-colors mb-2">
                    <i class="ph-bold ph-arrow-left text-base"></i>
                    {{ $backLabel ?? __('Back') }}
                </a>
            @endif
            <h1 class="text-xl sm:text-2xl font-bold tracking-tight text-white truncate">{{ $title }}</h1>
            @if($subtitle)
                <p class="mt-1 sm:mt-1.5 text-xs sm:text-sm text-slate-400 line-clamp-2">{{ $subtitle }}</p>
            @endif
        </div>

        @if(isset($actions))
            <div class="flex flex-wrap items-center gap-2 sm:gap-3 shrink-0">
                {{ $actions }}
            </div>
        @endif
    </div>
</div>

