@props([
    'paginator' => null,
    'simple' => false
])

@if($paginator && $paginator->hasPages())
    <nav class="flex flex-col sm:flex-row items-center justify-between gap-3 sm:gap-4" aria-label="@lang('Pagination')">
        <!-- Mobile: Current Page Info -->
        <div class="text-xs text-slate-500 sm:hidden text-center">
            @lang('Page') <span class="font-medium text-slate-300">{{ $paginator->currentPage() }}</span>
            @lang('of') <span class="font-medium text-slate-300">{{ $paginator->lastPage() }}</span>
            <span class="text-slate-600 mx-1">•</span>
            <span class="font-medium text-slate-300">{{ $paginator->total() }}</span> @lang('results')
        </div>

        <!-- Desktop: Results Info -->
        <div class="hidden text-sm text-slate-500 sm:block">
            @lang('Showing')
            <span class="font-medium text-slate-300">{{ $paginator->firstItem() }}</span>
            @lang('to')
            <span class="font-medium text-slate-300">{{ $paginator->lastItem() }}</span>
            @lang('of')
            <span class="font-medium text-slate-300">{{ $paginator->total() }}</span>
            @lang('results')
        </div>

        <!-- Pagination Links -->
        <div class="flex items-center gap-1 sm:gap-1">
            <!-- Previous -->
            @if($paginator->onFirstPage())
                <span class="flex h-10 w-10 sm:h-9 sm:w-9 cursor-not-allowed items-center justify-center rounded-lg text-slate-600" aria-disabled="true">
                    <i class="ph-bold ph-caret-left text-lg sm:text-base"></i>
                </span>
            @else
                <a href="{{ $paginator->previousPageUrl() }}" class="flex h-10 w-10 sm:h-9 sm:w-9 items-center justify-center rounded-lg text-slate-400 transition-all hover:bg-white/5 hover:text-white active:scale-95 active:bg-white/10" aria-label="@lang('Previous')">
                    <i class="ph-bold ph-caret-left text-lg sm:text-base"></i>
                </a>
            @endif

            @unless($simple)
                <!-- Mobile: Show limited page numbers -->
                <div class="hidden sm:flex gap-1">
                    @foreach($paginator->getUrlRange(max(1, $paginator->currentPage() - 2), min($paginator->lastPage(), $paginator->currentPage() + 2)) as $page => $url)
                        @if($page == $paginator->currentPage())
                            <span class="flex h-9 w-9 items-center justify-center rounded-lg bg-indigo-500 text-sm font-medium text-white" aria-current="page">
                                {{ $page }}
                            </span>
                        @else
                            <a href="{{ $url }}" class="flex h-9 w-9 items-center justify-center rounded-lg text-sm font-medium text-slate-400 transition-all hover:bg-white/5 hover:text-white active:scale-95">
                                {{ $page }}
                            </a>
                        @endif
                    @endforeach
                </div>

                <!-- Mobile: Compact page indicator -->
                <div class="flex sm:hidden items-center gap-1">
                    @if($paginator->currentPage() > 1)
                        <a href="{{ $paginator->url(1) }}" class="flex h-10 w-10 items-center justify-center rounded-lg text-sm font-medium text-slate-400 transition-all hover:bg-white/5 hover:text-white active:scale-95">
                            1
                        </a>
                        @if($paginator->currentPage() > 2)
                            <span class="px-1 text-slate-600">...</span>
                        @endif
                    @endif

                    <span class="flex h-10 min-w-10 px-2 items-center justify-center rounded-lg bg-indigo-500 text-sm font-medium text-white" aria-current="page">
                        {{ $paginator->currentPage() }}
                    </span>

                    @if($paginator->currentPage() < $paginator->lastPage())
                        @if($paginator->currentPage() < $paginator->lastPage() - 1)
                            <span class="px-1 text-slate-600">...</span>
                        @endif
                        <a href="{{ $paginator->url($paginator->lastPage()) }}" class="flex h-10 w-10 items-center justify-center rounded-lg text-sm font-medium text-slate-400 transition-all hover:bg-white/5 hover:text-white active:scale-95">
                            {{ $paginator->lastPage() }}
                        </a>
                    @endif
                </div>
            @endunless

            <!-- Next -->
            @if($paginator->hasMorePages())
                <a href="{{ $paginator->nextPageUrl() }}" class="flex h-10 w-10 sm:h-9 sm:w-9 items-center justify-center rounded-lg text-slate-400 transition-all hover:bg-white/5 hover:text-white active:scale-95 active:bg-white/10" aria-label="@lang('Next')">
                    <i class="ph-bold ph-caret-right text-lg sm:text-base"></i>
                </a>
            @else
                <span class="flex h-10 w-10 sm:h-9 sm:w-9 cursor-not-allowed items-center justify-center rounded-lg text-slate-600" aria-disabled="true">
                    <i class="ph-bold ph-caret-right text-lg sm:text-base"></i>
                </span>
            @endif
        </div>
    </nav>
@endif

