@props([
    'value' => 0,
    'max' => 100,
    'size' => 'default',
    'color' => 'primary',
    'showLabel' => false,
    'animated' => false
])

@php
    $percentage = min(100, max(0, ($value / $max) * 100));

    $sizes = [
        'sm' => 'h-1',
        'default' => 'h-2',
        'lg' => 'h-3',
    ];

    $colors = [
        'primary' => 'bg-indigo-500',
        'success' => 'bg-emerald-500',
        'warning' => 'bg-amber-500',
        'danger' => 'bg-rose-500',
        'info' => 'bg-sky-500',
    ];

    $sizeClass = $sizes[$size] ?? $sizes['default'];
    $colorClass = $colors[$color] ?? $colors['primary'];
@endphp

<div {{ $attributes->merge(['class' => 'space-y-2']) }}>
    @if($showLabel)
        <div class="flex justify-between text-sm">
            <span class="font-medium text-slate-300">{{ $slot->isNotEmpty() ? $slot : 'Progress' }}</span>
            <span class="text-slate-500">{{ round($percentage) }}%</span>
        </div>
    @endif

    <div class="overflow-hidden rounded-full bg-white/10 {{ $sizeClass }}">
        <div
            class="{{ $colorClass }} {{ $sizeClass }} rounded-full transition-all duration-500"
            style="width: {{ $percentage }}%"
            @if($animated)
            x-data
            x-init="setTimeout(() => $el.style.width = '{{ $percentage }}%', 100)"
            style="width: 0%"
            @endif
        ></div>
    </div>
</div>

