@props([
    'label' => null,
    'name' => null,
    'options' => [],
    'value' => null,
    'helper' => null,
    'error' => null,
    'inline' => false,
    'required' => false
])

@php
    $hasError = $error || (isset($errors) && $name && $errors->has($name));
    $errorMessage = $error ?? ($name ? $errors->first($name) : null);
@endphp

<div {{ $attributes->only('class')->merge(['class' => 'space-y-2']) }}>
    @if($label)
        <label @class(['label', 'label-required' => $required])>
            {{ $label }}
        </label>
    @endif
    
    <div @class([
        'space-y-2' => !$inline,
        'flex flex-wrap gap-4' => $inline
    ])>
        @foreach($options as $optionValue => $optionLabel)
            <x-admin.radio 
                :name="$name"
                :value="$optionValue"
                :label="$optionLabel"
                :checked="$value == $optionValue"
            />
        @endforeach
    </div>
    
    @if($helper && !$hasError)
        <p class="helper-text">{{ $helper }}</p>
    @endif
    
    @if($hasError)
        <p class="error-text">{{ $errorMessage }}</p>
    @endif
</div>

