@props([
    'label' => null,
    'name' => null,
    'id' => null,
    'value' => '',
    'checked' => false,
    'helper' => null,
    'disabled' => false
])

@php
    $inputId = $id ?? ($name ? $name . '_' . Str::slug($value) : uniqid('radio_'));
@endphp

<div {{ $attributes->only('class') }}>
    <label class="flex cursor-pointer items-start gap-3">
        <input
            type="radio"
            id="{{ $inputId }}"
            @if($name) name="{{ $name }}" wire:model="{{ $name }}" @endif
            value="{{ $value }}"
            @checked($checked)
            @disabled($disabled)
            {{ $attributes->except('class') }}
            @class([
                'mt-0.5 h-4 w-4 border-slate-300 text-primary-600 transition-colors focus:ring-2 focus:ring-primary-500/20 dark:border-slate-600 dark:bg-slate-700',
                'cursor-not-allowed opacity-50' => $disabled
            ])
        >

        <div class="flex-1">
            @if($label)
                <span @class([
                    'text-sm font-medium',
                    'text-slate-700 dark:text-slate-300' => !$disabled,
                    'text-slate-400 dark:text-slate-500' => $disabled
                ])>
                    {{ $label }}
                </span>
            @endif

            @if($helper)
                <p class="mt-0.5 text-xs text-slate-500 dark:text-slate-400">{{ $helper }}</p>
            @endif
        </div>
    </label>
</div>

