@props([
    'label' => null,
    'name' => null,
    'id' => null,
    'value' => '',
    'placeholder' => 'Start writing...',
    'helper' => null,
    'error' => null,
    'required' => false,
    'disabled' => false,
    'minHeight' => '200px'
])

@php
    $inputId = $id ?? $name ?? uniqid('editor_');
    $hasError = $error || (isset($errors) && $name && $errors->has($name));
    $errorMessage = $error ?? ($name ? $errors->first($name) : null);
@endphp

<div {{ $attributes->only('class')->merge(['class' => 'space-y-1']) }}>
    @if($label)
        <label for="{{ $inputId }}" @class(['label', 'label-required' => $required])>
            {{ $label }}
        </label>
    @endif
    
    <div @class([
        'overflow-hidden rounded-xl border',
        'border-slate-200' => !$hasError,
        'border-danger-500' => $hasError
    ])>
        <!-- Toolbar -->
        <div class="flex flex-wrap items-center gap-1 border-b border-slate-200 bg-slate-50 p-2">
            <button type="button" class="flex h-8 w-8 items-center justify-center rounded-lg text-slate-600 transition-colors hover:bg-slate-200" title="Bold">
                <i class="ph-bold ph-text-b"></i>
            </button>
            <button type="button" class="flex h-8 w-8 items-center justify-center rounded-lg text-slate-600 transition-colors hover:bg-slate-200" title="Italic">
                <i class="ph-bold ph-text-italic"></i>
            </button>
            <button type="button" class="flex h-8 w-8 items-center justify-center rounded-lg text-slate-600 transition-colors hover:bg-slate-200" title="Underline">
                <i class="ph-bold ph-text-underline"></i>
            </button>
            <div class="mx-1 h-5 w-px bg-slate-300"></div>
            <button type="button" class="flex h-8 w-8 items-center justify-center rounded-lg text-slate-600 transition-colors hover:bg-slate-200" title="Bullet List">
                <i class="ph-bold ph-list-bullets"></i>
            </button>
            <button type="button" class="flex h-8 w-8 items-center justify-center rounded-lg text-slate-600 transition-colors hover:bg-slate-200" title="Numbered List">
                <i class="ph-bold ph-list-numbers"></i>
            </button>
            <div class="mx-1 h-5 w-px bg-slate-300"></div>
            <button type="button" class="flex h-8 w-8 items-center justify-center rounded-lg text-slate-600 transition-colors hover:bg-slate-200" title="Link">
                <i class="ph-bold ph-link"></i>
            </button>
            <button type="button" class="flex h-8 w-8 items-center justify-center rounded-lg text-slate-600 transition-colors hover:bg-slate-200" title="Image">
                <i class="ph-bold ph-image"></i>
            </button>
            <button type="button" class="flex h-8 w-8 items-center justify-center rounded-lg text-slate-600 transition-colors hover:bg-slate-200" title="Code">
                <i class="ph-bold ph-code"></i>
            </button>
        </div>
        
        <!-- Editor Area -->
        <div 
            id="{{ $inputId }}"
            contenteditable="{{ $disabled ? 'false' : 'true' }}"
            class="prose prose-sm max-w-none p-4 focus:outline-none"
            style="min-height: {{ $minHeight }}"
            data-placeholder="{{ $placeholder }}"
        >{!! $value !!}</div>
        
        <!-- Hidden input for form submission -->
        <input type="hidden" @if($name) name="{{ $name }}" @endif>
    </div>
    
    @if($helper && !$hasError)
        <p class="helper-text">{{ $helper }}</p>
    @endif
    
    @if($hasError)
        <p class="error-text">{{ $errorMessage }}</p>
    @endif
</div>

@pushOnce('styles')
<style>
    [contenteditable]:empty:before {
        content: attr(data-placeholder);
        color: #94a3b8;
        pointer-events: none;
    }
</style>
@endPushOnce

