@props([
    'placeholder' => 'Search...',
    'name' => 'search',
    'shortcut' => null
])

<div class="relative">
    <div class="pointer-events-none absolute inset-y-0 left-0 flex items-center pl-4">
        <i class="ph-duotone ph-magnifying-glass text-lg text-slate-500"></i>
    </div>

    <input
        type="search"
        name="{{ $name }}"
        placeholder="{{ $placeholder }}"
        {{ $attributes->merge([
            'class' => 'w-full rounded-xl border border-white/10 bg-white/5 py-3 pl-11 pr-4 text-sm text-white placeholder-slate-500 transition-all focus:border-indigo-500/50 focus:bg-white/10 focus:outline-none focus:ring-2 focus:ring-indigo-500/20' . ($shortcut ? ' pr-14' : '')
        ]) }}
    >

    @if($shortcut)
        <kbd class="pointer-events-none absolute right-3 top-1/2 hidden -translate-y-1/2 rounded-lg border border-white/10 bg-white/5 px-2 py-0.5 text-xs text-slate-500 lg:block">
            {{ $shortcut }}
        </kbd>
    @endif
</div>

