@props([
    'label' => null,
    'name' => null,
    'id' => null,
    'placeholder' => null,
    'helper' => null,
    'error' => null,
    'required' => false,
    'disabled' => false,
    'options' => [],
])

@php
    $inputId = $id ?? $name ?? uniqid('select_');
    $hasWireModel = $attributes->whereStartsWith('wire:model')->isNotEmpty();

    // Auto-detect name from wire:model if missing
    if (!$name && $hasWireModel) {
        $name = $attributes->whereStartsWith('wire:model')->first();
    }

    $hasError = $error || (isset($errors) && $name && $errors->has($name));
    $errorMessage = $error ?? ($name ? $errors->first($name) : null);
@endphp

<div {{ $attributes->only('class')->merge(['class' => 'space-y-1.5 sm:space-y-2']) }}>
    @if($label)
        <label for="{{ $inputId }}" class="block text-xs sm:text-sm font-medium text-slate-300 {{ $required ? 'after:ml-0.5 after:text-rose-400 after:content-[\'*\']' : '' }}">
            {{ $label }}
        </label>
    @endif

    <div class="relative">
        <select
            id="{{ $inputId }}"
            @if($name) name="{{ $name }}" @endif
            @if($name && !$hasWireModel) wire:model="{{ $name }}" @endif
            class="block w-full appearance-none rounded-lg sm:rounded-xl border border-white/10 bg-white/5 px-3 sm:px-4 py-3 sm:py-3.5 pr-10 sm:pr-12 text-base sm:text-sm text-white transition-all focus:border-indigo-500/50 focus:bg-white/10 focus:outline-none focus:ring-2 focus:ring-indigo-500/20 disabled:cursor-not-allowed disabled:opacity-50 {{ $hasError ? 'border-rose-500/50 focus:border-rose-500/50 focus:ring-rose-500/20' : '' }}"
            @if($required) required @endif
            @if($disabled) disabled @endif
            {{ $attributes->except('class') }}
        >
            @if($placeholder)
                <option value="" class="bg-[#1a1a24] text-slate-400">{{ $placeholder }}</option>
            @endif

            @if($slot->isNotEmpty())
                {{ $slot }}
            @else
                @foreach($options as $value => $optionLabel)
                    <option value="{{ $value }}" class="bg-[#1a1a24]">{{ $optionLabel }}</option>
                @endforeach
            @endif
        </select>
        <span class="pointer-events-none absolute inset-y-0 right-0 flex items-center pr-3 sm:pr-4 text-slate-500">
            <i class="ph-bold ph-caret-down text-sm sm:text-base"></i>
        </span>
    </div>

    @if($helper && !$hasError)
        <p class="text-xs sm:text-sm text-slate-500">{{ $helper }}</p>
    @endif

    @if($hasError)
        <p class="flex items-center gap-1.5 text-xs sm:text-sm text-rose-400">
            <i class="ph-bold ph-warning-circle shrink-0"></i>
            {{ $errorMessage }}
        </p>
    @endif
</div>

