<!-- Admin Sidebar -->
<aside
    x-cloak
    x-persist="admin-sidebar"
    :class="[
        sidebarOpen ? 'w-[272px]' : 'w-20',
        sidebarMobileOpen ? 'translate-x-0' : '-translate-x-full lg:translate-x-0'
    ]"
    @touchstart.passive="touchStartX = $event.touches[0].clientX"
    @touchmove.passive="touchCurrentX = $event.touches[0].clientX"
    @touchend="if(touchStartX - touchCurrentX > 80) closeMobileSidebar(); touchStartX = 0; touchCurrentX = 0"
    class="fixed inset-y-0 left-0 z-50 flex flex-col border-r border-white/[0.04] bg-[#0f0f15] transition-all duration-300 will-change-transform"
>
    <!-- Mobile swipe indicator -->
    <div class="absolute right-0 top-1/2 -translate-y-1/2 w-1 h-16 bg-white/10 rounded-l-full lg:hidden"></div>

    <!-- Logo Section -->
    <div class="flex h-28 shrink-0 items-center justify-between px-4 lg:px-5">
        <a href="{{ route('admin.dashboard') }}" wire:navigate class="flex items-center gap-3 lg:gap-3.5">
            <div class="flex shrink-0 items-center justify-center transition-transform hover:scale-105 active:scale-95">
                <img src="{{ siteLogo() }}" alt="{{ gs('site_name') ?? 'Salieno' }}" class="h-20 w-auto object-contain" />
            </div>
        </a>

        <!-- Toggle Button (Desktop) -->
        <button
            @click="toggleSidebar()"
            x-show="sidebarOpen"
            class="hidden h-8 w-8 items-center justify-center rounded-xl text-slate-500 transition-all hover:bg-white/5 hover:text-white lg:flex"
        >
            <i class="ph-bold ph-sidebar-simple text-lg"></i>
        </button>

        <!-- Close Button (Mobile) - Larger touch target -->
        <button
            @click="closeMobileSidebar()"
            class="flex h-10 w-10 items-center justify-center rounded-xl text-slate-400 hover:bg-white/5 hover:text-white active:scale-95 transition-all lg:hidden"
        >
            <i class="ph-bold ph-x text-xl"></i>
        </button>
    </div>

    <!-- Expand Button (Desktop - Collapsed) -->
    <button
        @click="toggleSidebar()"
        x-show="!sidebarOpen"
        class="mx-auto mt-2 hidden h-8 w-8 items-center justify-center rounded-xl text-slate-500 transition-all hover:bg-white/5 hover:text-white lg:flex"
    >
        <i class="ph-bold ph-sidebar-simple text-lg"></i>
    </button>

    <!-- Navigation -->
    <nav class="scrollbar-thin mt-2 flex-1 overflow-y-auto px-4">
        <!-- Main Section -->
        <div x-show="sidebarOpen" class="mb-3 px-3 pt-2">
            <span class="text-[10px] font-bold uppercase tracking-[0.15em] text-slate-600">@lang('Main')</span>
        </div>
        <div class="space-y-1.5">
            <x-admin.nav-item icon="ph-squares-four" :label="__('Dashboard')" route="admin.dashboard" />
        </div>

        <!-- Users & Staff Section -->
        <div x-show="sidebarOpen" class="mb-3 mt-6 px-3">
            <span class="text-[10px] font-bold uppercase tracking-[0.15em] text-slate-600">@lang('Users & Staff')</span>
        </div>
        @php
            $kycPendingCount = \App\Models\User::where('kv', 2)->count();
        @endphp
        <div class="space-y-1.5" :class="!sidebarOpen && 'mt-4'">
            <x-admin.nav-group icon="ph-users-three" :label="__('Clients')" :expanded="request()->routeIs('admin.users.*')">
                <x-admin.nav-item icon="ph-user-check" :label="__('Active Clients')" route="admin.users.active" />
                <x-admin.nav-item icon="ph-user-minus" :label="__('Banned Clients')" route="admin.users.banned" />
                <x-admin.nav-item icon="ph-envelope-simple" :label="__('Email Unverified')" route="admin.users.email.unverified" />
                <x-admin.nav-item icon="ph-device-mobile" :label="__('Mobile Unverified')" route="admin.users.mobile.unverified" />
                <x-admin.nav-item icon="ph-wallet" :label="__('With Balance')" route="admin.users.with.balance" />
                <x-admin.nav-item icon="ph-users" :label="__('All Clients')" route="admin.users.all" />
                <x-admin.nav-item icon="ph-paper-plane-tilt" :label="__('Send Notification')" route="admin.users.notification.all" />
                <x-admin.nav-item icon="ph-user-plus" :label="__('Add New')" route="admin.users.create" />
            </x-admin.nav-group>

            <x-admin.nav-item icon="ph-identification-card" :label="__('KYC Management')" route="admin.kyc.index" :badge="$kycPendingCount > 0 ? $kycPendingCount : null" badgeType="warning" />

            <x-admin.nav-group icon="ph-user-gear" :label="__('Staff')" :expanded="request()->routeIs('admin.staff.*') || request()->routeIs('admin.roles.*')">
                <x-admin.nav-item icon="ph-users-four" :label="__('Staff Members')" route="admin.staff.index" />
                <x-admin.nav-item icon="ph-shield-check" :label="__('Roles & Permissions')" route="admin.roles.index" />
            </x-admin.nav-group>
        </div>

        <!-- Services Section -->
        <div x-show="sidebarOpen" class="mb-3 mt-6 px-3">
            <span class="text-[10px] font-bold uppercase tracking-[0.15em] text-slate-600">@lang('Services')</span>
        </div>
        <div class="space-y-1.5" :class="!sidebarOpen && 'mt-4'">
            <x-admin.nav-group icon="ph-package" :label="__('Products')" :expanded="request()->routeIs('admin.products.*')">
                <x-admin.nav-item icon="ph-cube" :label="__('All Products')" route="admin.products.all" />
                <x-admin.nav-item icon="ph-plus-circle" :label="__('Add Product')" route="admin.products.create" />
                <x-admin.nav-item icon="ph-folders" :label="__('Categories')" route="admin.products.categories" />
                <x-admin.nav-item icon="ph-sliders" :label="__('Config Options')" route="admin.products.configurable-groups" />
            </x-admin.nav-group>

            <x-admin.nav-group icon="ph-hard-drives" :label="__('Servers')" :expanded="request()->routeIs('admin.servers.*')">
                <x-admin.nav-item icon="ph-list-dashes" :label="__('All Servers')" route="admin.servers.all" />
                <x-admin.nav-item icon="ph-plus-circle" :label="__('Add Server')" route="admin.servers.create" />
                <x-admin.nav-item icon="ph-stack" :label="__('Server Groups')" route="admin.servers.groups" />
            </x-admin.nav-group>

            <x-admin.nav-group icon="ph-globe" :label="__('Domains')" :expanded="request()->routeIs('admin.domains') || request()->routeIs('admin.tld') || request()->routeIs('admin.domain.categories') || request()->routeIs('admin.register.domain')">
                <x-admin.nav-item icon="ph-list-dashes" :label="__('TLDs & Pricing')" route="admin.tld" />
                <x-admin.nav-item icon="ph-bookmarks" :label="__('TLD Categories')" route="admin.domain.categories" />
                <x-admin.nav-item icon="ph-link" :label="__('Registrars')" route="admin.register.domain" />
                <x-admin.nav-item icon="ph-database" :label="__('Client Domains')" route="admin.domains" />
            </x-admin.nav-group>

            <x-admin.nav-group icon="ph-cloud" :label="__('Active Services')" :expanded="request()->routeIs('admin.services') || request()->routeIs('admin.cancel.*')">
                <x-admin.nav-item icon="ph-hard-drive" :label="__('Hosting Services')" route="admin.services" />
                <x-admin.nav-item icon="ph-clock" :label="__('Pending Cancellations')" route="admin.cancel.pending" />
                <x-admin.nav-item icon="ph-check-circle" :label="__('Completed Cancellations')" route="admin.cancel.completed" />
                <x-admin.nav-item icon="ph-x-circle" :label="__('All Cancel Requests')" route="admin.cancel.requests" />
            </x-admin.nav-group>
        </div>

        <!-- Billing Section -->
        <div x-show="sidebarOpen" class="mb-3 mt-6 px-3">
            <span class="text-[10px] font-bold uppercase tracking-[0.15em] text-slate-600">@lang('Billing')</span>
        </div>
        <div class="space-y-1.5" :class="!sidebarOpen && 'mt-4'">
            <x-admin.nav-group icon="ph-shopping-cart" :label="__('Orders')" :expanded="request()->routeIs('admin.orders.*')">
                <x-admin.nav-item icon="ph-list-dashes" :label="__('All Orders')" route="admin.orders.index" />
                <x-admin.nav-item icon="ph-clock" :label="__('Pending Orders')" route="admin.orders.pending" />
                <x-admin.nav-item icon="ph-check-circle" :label="__('Active Orders')" route="admin.orders.active" />
            </x-admin.nav-group>

            <x-admin.nav-group icon="ph-file-text" :label="__('Invoices')" :expanded="request()->routeIs('admin.invoices.*')">
                <x-admin.nav-item icon="ph-clock" :label="__('Unpaid')" route="admin.invoices.unpaid" />
                <x-admin.nav-item icon="ph-hourglass" :label="__('Payment Pending')" route="admin.invoices.payment.pending" />
                <x-admin.nav-item icon="ph-check-circle" :label="__('Paid')" route="admin.invoices.paid" />
                <x-admin.nav-item icon="ph-x-circle" :label="__('Cancelled')" route="admin.invoices.cancelled" />
                <x-admin.nav-item icon="ph-arrow-counter-clockwise" :label="__('Refunded')" route="admin.invoices.refunded" />
                <x-admin.nav-item icon="ph-list-dashes" :label="__('All Invoices')" route="admin.invoices.index" />
            </x-admin.nav-group>

            <x-admin.nav-group icon="ph-credit-card" :label="__('Payments')" :expanded="request()->routeIs('admin.deposit.*') || request()->routeIs('admin.gateway.*')">
                <x-admin.nav-item icon="ph-clock" :label="__('Pending Deposits')" route="admin.deposit.pending" />
                <x-admin.nav-item icon="ph-check-circle" :label="__('Successful')" route="admin.deposit.successful" />
                <x-admin.nav-item icon="ph-x-circle" :label="__('Rejected')" route="admin.deposit.rejected" />
                <x-admin.nav-item icon="ph-hourglass" :label="__('Initiated')" route="admin.deposit.initiated" />
                <x-admin.nav-item icon="ph-money" :label="__('All Deposits')" route="admin.deposit.list" />
                <x-admin.nav-item icon="ph-lightning" :label="__('Auto Gateways')" route="admin.gateway.automatic.index" />
                <x-admin.nav-item icon="ph-hand-coins" :label="__('Manual Gateways')" route="admin.gateway.manual.index" />
            </x-admin.nav-group>

            <x-admin.nav-item icon="ph-ticket" :label="__('Coupons')" route="admin.coupons" />
        </div>

        <!-- Support Section -->
        <div x-show="sidebarOpen" class="mb-3 mt-6 px-3">
            <span class="text-[10px] font-bold uppercase tracking-[0.15em] text-slate-600">@lang('Support')</span>
        </div>
        <div class="space-y-1.5" :class="!sidebarOpen && 'mt-4'">
            <x-admin.nav-group icon="ph-headset" :label="__('Tickets')" :expanded="request()->routeIs('admin.ticket.*')">
                <x-admin.nav-item icon="ph-clock" :label="__('Pending')" route="admin.ticket.pending" />
                <x-admin.nav-item icon="ph-chat-circle-text" :label="__('Answered')" route="admin.ticket.answered" />
                <x-admin.nav-item icon="ph-x-circle" :label="__('Closed')" route="admin.ticket.closed" />
                <x-admin.nav-item icon="ph-list-dashes" :label="__('All Tickets')" route="admin.ticket.index" />
            </x-admin.nav-group>

            <x-admin.nav-group icon="ph-gear" :label="__('Management')" :expanded="request()->routeIs('admin.support.*')">
                <x-admin.nav-item icon="ph-folders" :label="__('Ticket Categories')" route="admin.support.categories" />
                <x-admin.nav-item icon="ph-chat-teardrop-dots" :label="__('Canned Responses')" route="admin.support.canned" />
                <x-admin.nav-item icon="ph-wrench" :label="__('Support Settings')" route="admin.ticket.setting" />
            </x-admin.nav-group>
        </div>

        <!-- Knowledge Base Section -->
        <div x-show="sidebarOpen" class="mb-3 mt-6 px-3">
            <span class="text-[10px] font-bold uppercase tracking-[0.15em] text-slate-600">@lang('Knowledge Base')</span>
        </div>
        <div class="space-y-1.5" :class="!sidebarOpen && 'mt-4'">
            <x-admin.nav-group icon="ph-books" :label="__('Knowledge Base')" :expanded="request()->routeIs('admin.kb.*')">
                <x-admin.nav-item icon="ph-folders" :label="__('Categories')" route="admin.kb.categories" />
                <x-admin.nav-item icon="ph-file-text" :label="__('Articles')" route="admin.kb.articles" />
            </x-admin.nav-group>
        </div>

        <!-- Reports Section -->
        <div x-show="sidebarOpen" class="mb-3 mt-6 px-3">
            <span class="text-[10px] font-bold uppercase tracking-[0.15em] text-slate-600">@lang('Reports')</span>
        </div>
        <div class="space-y-1.5" :class="!sidebarOpen && 'mt-4'">
            <x-admin.nav-item icon="ph-currency-circle-dollar" :label="__('Transactions')" route="admin.report.transaction" />
            <x-admin.nav-item icon="ph-user-list" :label="__('Login History')" route="admin.report.login.history" />
            <x-admin.nav-item icon="ph-bell" :label="__('Notification Log')" route="admin.report.notification.history" />
        </div>

        <!-- Settings Section -->
        <div x-show="sidebarOpen" class="mb-3 mt-6 px-3">
            <span class="text-[10px] font-bold uppercase tracking-[0.15em] text-slate-600">@lang('Settings')</span>
        </div>
        <div class="space-y-1.5" :class="!sidebarOpen && 'mt-4'">
            <x-admin.nav-group icon="ph-gear-six" :label="__('General')" :expanded="request()->routeIs('admin.setting.general') || request()->routeIs('admin.setting.store') || request()->routeIs('admin.setting.logo.*') || request()->routeIs('admin.billing.setting') || request()->routeIs('admin.automation.setting') || request()->routeIs('admin.kyc.setting') || request()->routeIs('admin.setting.client.area')">
                <x-admin.nav-item icon="ph-sliders-horizontal" :label="__('General Settings')" route="admin.setting.general" />
                <x-admin.nav-item icon="ph-storefront" :label="__('Store Settings')" route="admin.setting.store" />
                <x-admin.nav-item icon="ph-image" :label="__('Logo & Favicon')" route="admin.setting.logo.icon" />
                <x-admin.nav-item icon="ph-receipt" :label="__('Billing Settings')" route="admin.billing.setting" />
                <x-admin.nav-item icon="ph-robot" :label="__('Automation Settings')" route="admin.automation.setting" />
                <x-admin.nav-item icon="ph-identification-card" :label="__('KYC Settings')" route="admin.kyc.setting" />
                <x-admin.nav-item icon="ph-paint-brush-broad" :label="__('Client Area Settings')" route="admin.setting.client.area" />
            </x-admin.nav-group>

            <x-admin.nav-group icon="ph-bell-ringing" :label="__('Notifications')" :expanded="request()->routeIs('admin.setting.notification.*')">
                <x-admin.nav-item icon="ph-envelope" :label="__('Email Templates')" route="admin.setting.notification.templates" />
                <x-admin.nav-item icon="ph-gear" :label="__('Email Settings')" route="admin.setting.notification.email" />
                <x-admin.nav-item icon="ph-chat-circle" :label="__('SMS Settings')" route="admin.setting.notification.sms" />
                <x-admin.nav-item icon="ph-device-mobile" :label="__('Push Settings')" route="admin.setting.notification.push" />
            </x-admin.nav-group>

            <x-admin.nav-group icon="ph-code" :label="__('Advanced')" :expanded="request()->routeIs('admin.setting.custom.*') || request()->routeIs('admin.setting.cookie') || request()->routeIs('admin.setting.maintenance.*') || request()->routeIs('admin.setting.socialite.*') || request()->routeIs('admin.seo') || request()->routeIs('admin.robots.txt') || request()->routeIs('admin.sitemap') || request()->routeIs('admin.subscriber.*')">
                <x-admin.nav-item icon="ph-magnifying-glass" :label="__('SEO Settings')" route="admin.seo" />
                <x-admin.nav-item icon="ph-robot" :label="__('Robots.txt')" route="admin.robots.txt" />
                <x-admin.nav-item icon="ph-map-trifold" :label="__('Sitemap')" route="admin.sitemap" />
                <x-admin.nav-item icon="ph-envelope-simple" :label="__('Subscribers')" route="admin.subscriber.index" />
                <x-admin.nav-item icon="ph-file-css" :label="__('Custom CSS')" route="admin.setting.custom.css" />
                <x-admin.nav-item icon="ph-cookie" :label="__('Cookie Policy')" route="admin.setting.cookie" />
                <x-admin.nav-item icon="ph-wrench" :label="__('Maintenance Mode')" route="admin.setting.maintenance.mode" />
                <x-admin.nav-item icon="ph-share-network" :label="__('Social Login')" route="admin.setting.socialite.credentials" />
            </x-admin.nav-group>

            <x-admin.nav-item icon="ph-translate" :label="__('Languages')" route="admin.language.manage" />
        </div>

        <!-- Appearance Section -->
        <div x-show="sidebarOpen" class="mb-3 mt-6 px-3">
            <span class="text-[10px] font-bold uppercase tracking-[0.15em] text-slate-600">@lang('Appearance')</span>
        </div>
        <div class="space-y-1.5" :class="!sidebarOpen && 'mt-4'">
            <x-admin.nav-group icon="ph-layout" :label="__('Frontend')" :expanded="request()->routeIs('admin.frontend.*')">
                <x-admin.nav-item icon="ph-browser" :label="__('Templates')" route="admin.frontend.templates" />
                <x-admin.nav-item icon="ph-squares-four" :label="__('Sections')" route="admin.frontend.sections" />
                <x-admin.nav-item icon="ph-file-text" :label="__('Pages')" route="admin.frontend.manage.pages" />
            </x-admin.nav-group>

            <x-admin.nav-group icon="ph-list" :label="__('Menu Manager')" :expanded="request()->routeIs('admin.menus.*')">
                <x-admin.nav-item icon="ph-list-dashes" :label="__('All Menus')" route="admin.menus.index" />
                <x-admin.nav-item icon="ph-share-network" :label="__('Social Links')" route="admin.menus.social-links" />
            </x-admin.nav-group>
        </div>

        <!-- System Section -->
        <div x-show="sidebarOpen" class="mb-3 mt-6 px-3">
            <span class="text-[10px] font-bold uppercase tracking-[0.15em] text-slate-600">@lang('System')</span>
        </div>
        <div class="space-y-1.5" :class="!sidebarOpen && 'mt-4'">
            <x-admin.nav-item icon="ph-clock-countdown" :label="__('Cron Jobs')" route="admin.cron.index" />
            <x-admin.nav-item icon="ph-warning-octagon" :label="__('Automation Errors')" route="admin.automation.errors" />
            <x-admin.nav-item icon="ph-bug" :label="__('Report & Request')" route="admin.report.request" />
            <x-admin.nav-item icon="ph-info" :label="__('System Info')" route="admin.system.info" />
            <x-admin.nav-item icon="ph-rocket" :label="__('Optimize')" route="admin.system.optimize" />
            <x-admin.nav-item icon="ph-arrow-circle-up" :label="__('Updates')" route="admin.system.update" />
            <x-admin.nav-group icon="ph-shield-check" :label="__('System Registry')" :expanded="request()->routeIs('admin.system.*')">
                <x-admin.nav-item icon="ph-info" :label="__('System Status')" route="admin.system.status" />
                <x-admin.nav-item icon="ph-key" :label="__('System Registration')" route="admin.system.register" />
            </x-admin.nav-group>
        </div>
    </nav>

    <!-- Sidebar Footer / User Section -->
    <div class="shrink-0 border-t border-white/5 p-3 lg:p-4 pb-safe">
        <div
            x-data="{ userMenuOpen: false }"
            class="relative"
        >
            <button
                @click="userMenuOpen = !userMenuOpen"
                class="flex w-full items-center gap-3 rounded-xl p-2 text-left transition-all hover:bg-white/5 active:scale-[0.98] min-h-[48px]"
                :class="!sidebarOpen && 'justify-center p-2.5'"
            >
                <!-- User Avatar -->
                <div class="relative shrink-0">
                    <div class="flex h-10 w-10 items-center justify-center rounded-xl bg-gradient-to-br from-indigo-400 via-purple-400 to-pink-400 text-sm font-bold text-white shadow-lg shadow-purple-500/20">
                        {{ strtoupper(substr(auth()->guard('admin')->user()->name ?? 'A', 0, 1)) }}
                    </div>
                    <span class="absolute -bottom-0.5 -right-0.5 h-3 w-3 rounded-full border-2 border-[#0f0f15] bg-emerald-400"></span>
                </div>

                <!-- User Info -->
                <div x-show="sidebarOpen" class="min-w-0 flex-1">
                    <p class="truncate text-sm font-semibold text-white">{{ auth()->guard('admin')->user()->name ?? 'Admin' }}</p>
                    <p class="truncate text-xs text-slate-500">@lang('Administrator')</p>
                </div>

                <!-- Dropdown Icon -->
                <div x-show="sidebarOpen" class="rounded-lg bg-white/5 p-1.5">
                    <i class="ph-bold ph-caret-up-down text-xs text-slate-400"></i>
                </div>
            </button>

            <!-- Dropdown Menu -->
            <div
                x-show="userMenuOpen"
                x-transition:enter="transition ease-out duration-150"
                x-transition:enter-start="opacity-0 translate-y-2"
                x-transition:enter-end="opacity-100 translate-y-0"
                x-transition:leave="transition ease-in duration-100"
                x-transition:leave-start="opacity-100 translate-y-0"
                x-transition:leave-end="opacity-0 translate-y-2"
                @click.away="userMenuOpen = false"
                class="absolute bottom-full left-0 right-0 mb-3 overflow-hidden rounded-2xl border border-white/10 bg-[#1a1a24] p-2 shadow-2xl shadow-black/40"
                :class="!sidebarOpen && 'left-full ml-3 bottom-0 w-56'"
            >
                <a href="{{ route('admin.profile') }}" wire:navigate class="flex items-center gap-3 rounded-xl px-4 py-3.5 text-sm text-slate-300 transition-all hover:bg-white/5 hover:text-white active:scale-[0.98] min-h-[48px]">
                    <i class="ph-duotone ph-user-circle text-lg text-indigo-400"></i>
                    @lang('My Profile')
                </a>
                <a href="{{ route('admin.setting.general') }}" wire:navigate class="flex items-center gap-3 rounded-xl px-4 py-3.5 text-sm text-slate-300 transition-all hover:bg-white/5 hover:text-white active:scale-[0.98] min-h-[48px]">
                    <i class="ph-duotone ph-gear text-lg text-slate-400"></i>
                    @lang('Settings')
                </a>
                <div class="my-2 border-t border-white/5"></div>
                <form method="POST" action="{{ route('admin.logout') }}">
                    @csrf
                    <button type="submit" class="flex w-full items-center gap-3 rounded-xl px-4 py-3.5 text-sm text-rose-400 transition-all hover:bg-rose-500/10 hover:text-rose-300 active:scale-[0.98] min-h-[48px]">
                        <i class="ph-duotone ph-sign-out text-lg"></i>
                        @lang('Sign Out')
                    </button>
                </form>
            </div>
        </div>
    </div>
</aside>

