@props([
    'type' => 'text',
    'lines' => 3,
    'width' => 'full',
    'height' => '4'
])

@php
    $widthClasses = [
        'full' => 'w-full',
        '3/4' => 'w-3/4',
        '2/3' => 'w-2/3',
        '1/2' => 'w-1/2',
        '1/3' => 'w-1/3',
        '1/4' => 'w-1/4',
    ];

    $heightClasses = [
        '2' => 'h-2',
        '3' => 'h-3',
        '4' => 'h-4',
        '5' => 'h-5',
        '6' => 'h-6',
        '8' => 'h-8',
        '10' => 'h-10',
        '12' => 'h-12',
        '16' => 'h-16',
        '20' => 'h-20',
        '24' => 'h-24',
        '32' => 'h-32',
        '48' => 'h-48',
    ];

    $widthClass = $widthClasses[$width] ?? $widthClasses['full'];
    $heightClass = $heightClasses[$height] ?? $heightClasses['4'];
@endphp

@switch($type)
    @case('text')
        <div class="space-y-2.5">
            @for($i = 0; $i < $lines; $i++)
                <div @class([
                    'skeleton rounded',
                    $heightClass,
                    $i === $lines - 1 ? 'w-2/3' : $widthClass,
                ])></div>
            @endfor
        </div>
        @break

    @case('avatar')
        <div class="skeleton h-10 w-10 sm:h-12 sm:w-12 rounded-full"></div>
        @break

    @case('card')
        <div class="card p-4 sm:p-6">
            <div class="flex items-center gap-3 sm:gap-4">
                <div class="skeleton h-10 w-10 sm:h-12 sm:w-12 rounded-xl shrink-0"></div>
                <div class="flex-1 space-y-1.5 sm:space-y-2">
                    <div class="skeleton h-3 sm:h-4 w-1/3 rounded"></div>
                    <div class="skeleton h-2.5 sm:h-3 w-1/2 rounded"></div>
                </div>
            </div>
            <div class="mt-4 sm:mt-6 space-y-2 sm:space-y-2.5">
                <div class="skeleton h-2.5 sm:h-3 w-full rounded"></div>
                <div class="skeleton h-2.5 sm:h-3 w-full rounded"></div>
                <div class="skeleton h-2.5 sm:h-3 w-2/3 rounded"></div>
            </div>
        </div>
        @break

    @case('stat')
        <div class="card p-3 sm:p-6">
            <div class="flex items-start justify-between gap-2">
                <div class="skeleton h-10 w-10 sm:h-12 sm:w-12 rounded-lg sm:rounded-xl"></div>
                <div class="skeleton h-5 sm:h-6 w-12 sm:w-16 rounded-full"></div>
            </div>
            <div class="mt-3 sm:mt-4 space-y-1.5 sm:space-y-2">
                <div class="skeleton h-6 sm:h-8 w-16 sm:w-24 rounded"></div>
                <div class="skeleton h-3 sm:h-4 w-20 sm:w-32 rounded"></div>
            </div>
        </div>
        @break

    @case('mobile-card')
        <div class="card p-3 sm:p-4">
            <div class="flex items-start justify-between gap-3">
                <div class="flex items-center gap-3 min-w-0 flex-1">
                    <div class="skeleton h-10 w-10 rounded-full shrink-0"></div>
                    <div class="flex-1 space-y-1.5">
                        <div class="skeleton h-3 w-3/4 rounded"></div>
                        <div class="skeleton h-2.5 w-1/2 rounded"></div>
                    </div>
                </div>
                <div class="skeleton h-5 w-12 rounded-full"></div>
            </div>
            <div class="mt-3 grid grid-cols-2 gap-2">
                <div class="skeleton h-2.5 w-full rounded"></div>
                <div class="skeleton h-2.5 w-full rounded"></div>
            </div>
        </div>
        @break

    @case('table-row')
        <tr>
            <td class="px-3 sm:px-4 py-2.5 sm:py-3">
                <div class="skeleton h-3 sm:h-4 w-3/4 rounded"></div>
            </td>
            <td class="px-3 sm:px-4 py-2.5 sm:py-3">
                <div class="skeleton h-3 sm:h-4 w-1/2 rounded"></div>
            </td>
            <td class="px-3 sm:px-4 py-2.5 sm:py-3 hidden sm:table-cell">
                <div class="skeleton h-3 sm:h-4 w-2/3 rounded"></div>
            </td>
            <td class="px-3 sm:px-4 py-2.5 sm:py-3">
                <div class="skeleton h-5 sm:h-6 w-12 sm:w-16 rounded-full"></div>
            </td>
            <td class="px-3 sm:px-4 py-2.5 sm:py-3">
                <div class="skeleton h-7 sm:h-8 w-7 sm:w-8 rounded-lg"></div>
            </td>
        </tr>
        @break

    @case('image')
        <div class="skeleton {{ $widthClass }} {{ $heightClass }} rounded-xl"></div>
        @break

    @default
        <div class="skeleton {{ $widthClass }} {{ $heightClass }} rounded"></div>
@endswitch

