@props([
    'icon' => 'ph-chart-line-up',
    'iconColor' => 'primary',
    'label' => '',
    'value' => '0',
    'trend' => null,
    'trendLabel' => null,
    'href' => null,
    'compact' => false,
])

@php
    $iconStyles = [
        'primary' => 'bg-indigo-500/10 text-indigo-400 ring-indigo-500/20',
        'success' => 'bg-emerald-500/10 text-emerald-400 ring-emerald-500/20',
        'warning' => 'bg-amber-500/10 text-amber-400 ring-amber-500/20',
        'danger' => 'bg-rose-500/10 text-rose-400 ring-rose-500/20',
        'info' => 'bg-sky-500/10 text-sky-400 ring-sky-500/20',
    ];

    $iconStyle = $iconStyles[$iconColor] ?? $iconStyles['primary'];

    $trendPositive = $trend !== null && $trend >= 0;

    $gradientColor = match($iconColor) {
        'primary' => 'indigo',
        'success' => 'emerald',
        'warning' => 'amber',
        'danger' => 'rose',
        default => 'sky',
    };
@endphp

<div {{ $attributes->merge(['class' => 'group relative overflow-hidden rounded-xl sm:rounded-2xl border border-white/5 bg-[#12121a] p-4 sm:p-6 shadow-xl shadow-black/10 transition-all hover:border-white/10 active:scale-[0.99]']) }}>
    <!-- Decorative gradient -->
    <div class="pointer-events-none absolute -right-8 -top-8 h-24 sm:h-32 w-24 sm:w-32 rounded-full bg-gradient-to-br from-{{ $gradientColor }}-500/10 blur-2xl"></div>

    <div class="relative flex items-start justify-between gap-3">
        <div class="flex h-10 w-10 sm:h-12 sm:w-12 shrink-0 items-center justify-center rounded-lg sm:rounded-xl ring-1 {{ $iconStyle }}">
            <i class="ph-duotone {{ $icon }} text-xl sm:text-2xl"></i>
        </div>

        @if($trend !== null)
            <span @class([
                'inline-flex items-center gap-1 rounded-md sm:rounded-lg px-2 sm:px-2.5 py-0.5 sm:py-1 text-[10px] sm:text-xs font-semibold shrink-0',
                'bg-emerald-500/15 text-emerald-400' => $trendPositive,
                'bg-rose-500/15 text-rose-400' => !$trendPositive,
            ])>
                <i @class([
                    'ph-bold text-[8px] sm:text-[10px]',
                    'ph-arrow-up' => $trendPositive,
                    'ph-arrow-down' => !$trendPositive,
                ])></i>
                {{ abs($trend) }}%
            </span>
        @endif
    </div>

    <div class="relative mt-3 sm:mt-5">
        <p class="text-2xl sm:text-3xl font-bold tracking-tight text-white truncate">{{ $value }}</p>
        <p class="mt-1 sm:mt-1.5 text-xs sm:text-sm text-slate-400 truncate">{{ $label }}</p>

        @if($trend !== null)
            <p class="mt-1.5 sm:mt-2 text-[10px] sm:text-xs text-slate-500 hidden sm:block">{{ $trendLabel ?? __('vs last period') }}</p>
        @endif
    </div>

    @if($href)
        <a href="{{ $href }}" class="relative mt-3 sm:mt-4 inline-flex items-center gap-1.5 text-xs sm:text-sm font-medium text-indigo-400 sm:opacity-0 transition-all sm:group-hover:opacity-100 hover:text-indigo-300 min-h-[44px] sm:min-h-0 active:scale-95">
            @lang('View details')
            <i class="ph-bold ph-arrow-right text-xs transition-transform group-hover:translate-x-0.5"></i>
        </a>
    @endif
</div>

